{ pkgs, ... }:
{
  # i18n.inputMethod = {
  #   enabled = true; type = "ibus";
  #   ibus.engines = with pkgs.ibus-engines; [ mozc ];
  # };

  # boot.kernelPackages = pkgs.linuxPackages_hardened;
  # nix.settings.sandbox = false; # nix.settings.trusted-users = [ "root" ];

  security.rtkit.enable = true;
  security.pam.services.swaylock = {};
  environment.sessionVariables.NIXOS_OZONE_WL = "1";

  # a number of forum pages describe the same error... only one had a good resolution.
  # https://discourse.nixos.org/t/rebuild-error-failed-to-start-network-manager-wait-online/41977
  systemd.network.wait-online.enable = false;
    # ProtectHome
    # NoNewPrivileges = true;
    # ProtectKernelLogs = true;
    # ProtectKernelModules = true;
    # ProtectKernelTunables = true;
  # }

  boot.initrd.systemd.network.wait-online.enable = false;

  # security.pam.services.gdm.enableGnomeKeyring = true;
  services = {
    # libinput = { enable = true; layout = "us"; xkbOptions = "caps:ctrl"; };
    atuin.enable = true;
    avahi = { enable = true; }; # nssmdns4 = true; }; openFirewall = true; # for a WiFi printer
    blueman.enable = true;
    dbus.enable = true;
    # fprintd.enable = true; # bio login
    # input-remapper.enable = true;
    ollama.enable = true;
    printing.enable = true;

    # tor.client.enable = true;
    ntp.enable = true;

    # fprintd.tod.enable = true;
    # (If the vfs0090 Driver does not work, use the following driver)
    # fprintd.tod.driver = pkgs.libfprint-2-tod1-vfs0090;
    # (On my device it only worked with this driver)
    # fprintd.tod.driver = pkgs.libfprint-2-tod1-goodix;

    pipewire = { enable = true;
      alsa.enable = true;
      alsa.support32Bit = true;
      pulse.enable = true;
      jack.enable = true;
      wireplumber = { enable = true;
        extraConfig."10-bluez"."monitor.bluez.properties" = {
          "bluez5.enable-sbc-xq" = true;
          "bluez5.enable-msbc" = true;
          "bluez5.enable-hw-volume" = true;
          "bluez5.roles" = [ "hsp_hs" "hsp_ag" "hfp_hf" "hfp_ag" ];
    }; }; };

    # pantheon.apps.enable = false;
    # picom = { enable = true; fade = true; inactiveOpacity = 0.9; shadow = true; fadeDelta = 4; };
    # flatpak.enable = true;

    xserver = { enable = true;
      # settings.Autologin.User = "calliope";
      # settings.Autologin = { Session = "hyprland"; User = "calliope"; }; };

      # displayManager.lightdm.enable = true;
      # displayManager.sddm = { enable = true; wayland.enable = true; };

      # displayManager.defaultSession = "pantheon";# "hyprland"; "cinnamon"; "plasmawayland"; "xfce";
      # desktopManager.cinnamon.enable = true;
      # desktopManager.plasma5.enable = true;
      # desktopManager.xfce.enable = true;
      # desktopManager.pantheon.enable = true;

      # libinput.enable = true; # Enable touchpad
      # displayManager.sessionCommands =
      #   ''${lib.getBin pkgs.xorg.xrandr}/bin/xrandr --setprovideroutputsource 2 0'';

      videoDrivers = [ "modesetting" "nvidia" ];
    };

    pulseaudio = { enable = false; extraConfig = "load-module module-switch-on-connect"; };
  };

  hardware = {
    bluetooth = { enable = true; powerOnBoot = true; };
    sane = { enable = true; extraBackends = with pkgs; [ utsushi ]; };
    graphics.enable = true;
    nvidia = { open = false; modesetting.enable = true; };
  };

  environment.systemPackages = with pkgs; [ egl-wayland fuse3.dev ];
}
