{
    services.caddy.virtualHosts."node.operand.online".extraConfig = ''

    log {
      output file /var/lib/caddy/node.operand.online.log {
        roll_size     200MiB
        roll_local_time
        roll_keep     1440
        roll_keep_for 1440d
      }
    }

    # https://caddyserver.com/docs/caddyfile/directives/redir#syntax
    redir /nodeworks/pay.php      /nodeworks/dues.html     permanent
    redir /nodeworks/donation.php /nodeworks/donation.html permanent

    handle /nodeworks/* {
        root /node
        file_server
    }

    # https://caddyserver.com/docs/caddyfile/directives/reverse_proxy
    handle /* {
    reverse_proxy http://127.0.0.1:2222
    # reverse_proxy https://nostalgic-uakari.pikapod.net {
      # transport http {
      #   tls_insecure_skip_verify
      # }
    # }
    }

    '';
}


#     location / {
#         proxy_pass https://nostalgic-uakari.pikapod.net/;
#         proxy_ssl_server_name on;
#     }

#     root /home/nodepress/www.baltimorenode.org/www;
# 
# }
