{ name, channel ? "background", pkg }:
{...}:
{
  networking.firewall.allowedTCPPorts = [ channel ];
  environment.systemPackages = [ pkg ];
  systemd.services."${name}" = { enable = true;
    description = "${name}, on :${toString channel}";
    wantedBy = ["multi-user.target"];
    unitConfig = { After = "local-fs.target"; Wants = "local-fs.target"; };

    serviceConfig = {
      ExecStart = "${pkg}/bin/${name}";
      Type = "exec";
      KillMode = "process";
      TimeoutSec = 0;
      Restart = "always";
    };
}; }
