{ pkgs, ...}:
{
  networking.firewall.allowedTCPPorts = [ 5432 ];
  services.postgresql = {
    enable = true; enableTCPIP = true; settings.port = 5432;
    # package = pkgs.postgresql_16;
    # extensions = with pkgs.postgresql15Packages; [ pgvector postgis ];
    settings.password_encryption = "scram-sha-256";
    # ensureUsers = [
    #   { name = "calliope"; } # ensureDBOwnership = true; }
    #   { name = "immich"; } # ensureDBOwnership = true; }
    # ];

    authentication = pkgs.lib.mkOverride 5 ''
    local all all trust
    host  all all 127.0.0.1/32   trust
    host  all all ::1/128        trust

    host all postgres 0.0.0.0/0 scram-sha-256
    host all read 0.0.0.0/0 scram-sha-256
    '';
  };
}
