import Config

config :op, Op.Repo,
  username: "postgres",
  password: "postgres",
  hostname: "localhost",
  database: "op_dev",
  stacktrace: true,
  show_sensitive_data_on_connection_error: true,
  pool_size: 10

# In local mode, disable any cache and enable debugging and code reloading.
config :op, OpWeb.Endpoint,
  # Binding to loopback ipv4 address prevents access from other machines.
  # Change to `ip: {0, 0, 0, 0}` to allow access from other machines.
  http: [ip: {0, 0, 0, 0}, port: System.get_env("CHANNEL") || 4000],
  server: true,
  check_origin: false,
  code_reloader: true,
  debug_errors: true,
  secret_key_base: "avR6uqY18Kt3gaQQ1PokR98MDe475dv2yWOILylV0Pl/7bAj8Q49R/LdE5NYPSIZ",
  live_reload: [
    patterns: [
      ~r"lib/pain_web/(controllers|live|components)/.*(ex|heex|sface|js)$",
      ~r"priv/catalogue/.*(ex)$",
      ~r"priv/gettext/.*(po)$",
      ~r"priv/static/.*(js|css|png|jpeg|jpg|gif|svg)$"
    ],
    reload_page_on_css_changes: true
  ],
  reloadable_compilers: [:gettext, :elixir, :app, :surface],
  watchers: [
    vite: {PhoenixVite, :run, ["npx", ~w(vite dev), [cd: "assets"]]}
  ],
  static_url: [host: "localhost", port: 5173]

# Watch static and templates for browser reloading.
config :op, OpWeb.Endpoint,
  live_reload: [
    reload_page_on_css_changes: true,
    patterns: [
      ~r"priv/static/.*(js|css|png|jpeg|jpg|gif|svg)$",
      ~r"priv/gettext/.*(po)$",
      ~r"lib/op_web/(controllers|live|components)/.*(ex|heex)$",
      ~r"page/*",
    ]
  ]

# Enable dev routes for dashboard and mailbox
config :op, dev_routes: true

# Do not include metadata nor timestamps in development logs
config :logger, :console, format: "[$level] $message\n"

# Set a higher stacktrace during development.
# Avoid configuring such in production as building large stacktraces may be expensive.
config :phoenix, :stacktrace_depth, 20

# Initialize plugs at runtime for faster development compilation
config :phoenix, :plug_init_mode, :runtime

# Include HEEx debug annotations as HTML comments in rendered markup
config :phoenix_live_view, :debug_heex_annotations, true

# Disable swoosh api client as it is only required for production adapters.
# config :swoosh, :api_client, false

fallback = &if !System.get_env(&1), do: System.put_env(&1, "")
["SUPER_USER", "SUPER_PASS"] |> Enum.each(fallback)
