import Config

# Note we also include the path to a cache manifest
# containing the digested version of static files. This
# manifest is generated by the `mix assets.deploy` task,
# which you should run after static files are built and
# before starting your production server.
config :op, OpWeb.Endpoint,
  server: true,
  url: [host: System.get_env("DOMAIN"), port: 443, scheme: "https"],
  http: [ip: {127, 0, 0, 1}, port: System.get_env("CHANNEL")],
  secret_key_base: System.get_env("SECRET_KEY_BASE"),
  live_reload: [patterns: [~r"share/*$"]]

# Configures Swoosh API Client
# config :swoosh, api_client: Swoosh.ApiClient.Finch, finch_name: Op.Finch

# Disable Swoosh Local Memory Storage
# config :swoosh, local: false

# Do not print debug messages in production
config :logger, level: :info

# Runtime production configuration, including reading
# of environment variables, is done on config/runtime.exs.
