import Config
config :ash, disable_async?: true
config :op, Oban, testing: :manual

# Configure your database
#
# The MIX_TEST_PARTITION environment variable can be used
# to provide built-in test partitioning in CI environment.
# Run `mix help test` for more information.
config :op, Op.Repo,
  username: "postgres",
  password: "postgres",
  hostname: "localhost",
  database: "op_test#{System.get_env("MIX_TEST_PARTITION")}",
  pool: Ecto.Adapters.SQL.Sandbox,
  pool_size: 10

# We don't run a server during test. If one is required,
# you can enable the server option below.
config :op, OpWeb.Endpoint,
  http: [ip: {127, 0, 0, 1}, port: 4002],
  secret_key_base: "Gva00yQM1G3nsE9PtGwVl+4GPIRwfv5BGk4hCzz4t7B7Pjz8DREClJTLT0OM6SB5",
  server: false

# In test we don't send emails.
config :op, Op.Mailer, adapter: Swoosh.Adapters.Test

# Disable swoosh api client as it is only required for production adapters.
config :swoosh, :api_client, false

# Print only warnings and errors during test
config :logger, level: :warning

# Initialize plugs at runtime for faster test compilation
config :phoenix, :plug_init_mode, :runtime

fallback = &if !System.get_env(&1), do: System.put_env(&1, "")
["SUPER_USER", "SUPER_PASS"] |> Enum.each(fallback)
