defmodule Op.Communique.Message do
  use Ash.Resource, otp_app: :op, domain: Op.Communique, data_layer: AshPostgres.DataLayer

  attributes do
    uuid_primary_key :key

    attribute :handle, :string do
      allow_nil?(false)
      public?(true)
    end

    attribute :email, :string do
      allow_nil?(false)
      sensitive?(true)
    end

    attribute :channel, :string do
      allow_nil?(false)
      public?(true)
    end

    attribute :body, :string do
      allow_nil?(false)
      public?(true)
    end

    attribute :published, :datetime do
      public?(true)
    end

    timestamps()
  end

  actions do
    defaults([:read])
  end

  postgres do
    table "messages"
    repo Op.Repo
  end
end
