defmodule Op.MixProject do
  use Mix.Project

  def project do
    [
      app: :op,
      version: "0.1.0",
      elixir: "~> 1.16",
      elixirc_paths: elixirc_paths(Mix.env()),
      start_permanent: Mix.env() == :prod,
      aliases: aliases(),
      deps: deps(),
      docs: [
        main: "readme",
        canonical: "https://share.operand.space/code/op/doc/readme.html",
        extras: ["README.md"]
      ]
    ]
  end

  # Configuration for the OTP application.
  #
  # Type `mix help compile.app` for more information.
  def application do
    [
      mod: {Op.Application, []},
      extra_applications: [:yaml_front_matter, :logger, :runtime_tools]
    ]
  end

  # Specifies which paths to compile per environment.
  defp elixirc_paths(:test), do: ["lib", "test/support"]
  defp elixirc_paths(_), do: ["lib"]

  # Specifies your project dependencies.
  #
  # Type `mix help deps` for examples and options.
  defp deps do
    [
      {:ash_postgres, "~> 2.0"},
      {:ash_admin, "~> 0.13.14"},
      {:bandit, "~> 1.5"},
      {:boltx, "~> 0.0.6"},
      {:call, "~> 0.0.2"},
      {:dns_cluster, "~> 0.1.1"},
      {:ecto_sql, "~> 3.10"},
      {:ex_doc, "~> 0.14", only: :dev, runtime: false},
      {:ex_heroicons, "~> 3.1"},
      {:heroicons,
       github: "tailwindlabs/heroicons",
       tag: "v2.1.5",
       sparse: "optimized",
       app: false,
       compile: false,
       depth: 1},
      {:finch, "~> 0.13"},
      {:floki, ">= 0.30.0", only: :test},
      {:gettext, "~> 0.20"},
      {:git_cli, "~> 0.3"},
      {:jason, "~> 1.2"},
      {:live_debugger, "~> 0.3.0", only: :dev},
      {:mdex, "~> 0.1"},
      {:oban, "~> 2.19"},
      {:oban_web, "~> 2.11"},
      {:phoenix, "~> 1.7.10"},
      {:phoenix_ecto, "~> 4.5"},
      {:phoenix_html, "~> 4.1"},
      {:phoenix_html_helpers, "~> 1.0"},
      {:phoenix_sync, "~> 0.3"},
      {:phoenix_live_dashboard, "~> 0.8.2"},
      {:phoenix_live_reload, "~> 1.2", only: :dev},
      {:phoenix_live_view, "~> 1.0"},
      {:postgrex, ">= 0.0.0"},
      {:telemetry_metrics, "~> 0.6"},
      {:telemetry_poller, "~> 1.0"},
      {:tox, "~> 0.2"},
      {:yaml_front_matter, "~> 1.0"},
      {:igniter, "~> 0.6"},
      {:phoenix_vite, "~> 0.2"}
    ]
  end

  # Aliases are shortcuts or tasks specific to the current project.
  # For example, to install project dependencies and perform other setup tasks, run:
  #
  #     $ mix setup
  #
  # See the documentation for `Mix` for more info on aliases.
  defp aliases do
    [
      upgrade: ["deps.get", "ash.setup"],
      setup: ["assets.build", "run priv/repo/seeds.exs"],
      "ecto.setup": ["ecto.create", "ecto.migrate", "run priv/repo/seeds.exs"],
      "ecto.reset": ["ecto.drop", "ecto.setup"],
      test: ["ash.setup --quiet", "test"],
      "assets.build": [
        "cmd --cd assets yarn install --production",
        "cmd --cd assets npx vite build",
      ],
    ]
  end
end
