# This file is responsible for configuring your application
# and its dependencies with the aid of the Config module.
#
# This configuration file is loaded before any dependency and
# is restricted to this project.

# General application configuration
import Config

config :spark, formatter: ["Ash.Resource": [section_order: [:postgres]]]

config :op, Oban,
  engine: Oban.Engines.Basic,
  notifier: Oban.Notifiers.Postgres,
  queues: [default: 10],
  repo: Op.Repo

config :op,
  ecto_repos: [Op.Repo],
  generators: [timestamp_type: :utc_datetime],
  ash_domains: [Op.Communique]

config :boltx, Bolt,
  uri: System.get_env("GRAPH_ADDR"),
  auth: [username: "neo4j", password: "abcd1234"],
  user_agent: "boltx@op",
  pool_size: 15,
  max_overflow: 3,
  prefix: :default, # op ?
  name: Bolt

# Configures the endpoint
config :op, OpWeb.Endpoint,
  url: [host: System.get_env("DOMAIN") || "0.0.0.0"],
  adapter: Bandit.PhoenixAdapter,
  render_errors: [
    formats: [html: OpWeb.ErrorHTML, json: OpWeb.ErrorJSON],
    layout: false
  ],
  pubsub_server: Op.PubSub,
  live_view: [signing_salt: "awUooU+4"]

config :ex_heroicons, type: "solid"

# Configures the mailer
#
# By default it uses the "Local" adapter which stores the emails
# locally. You can see the emails in your browser, at "/dev/mailbox".
#
# For production it's recommended to configure a different adapter
# at the `config/runtime.exs`.
# config :op, Op.Mailer, adapter: Swoosh.Adapters.Local

# Configures Elixir's Logger
config :logger, :console,
  format: "$time $metadata[$level] $message\n",
  metadata: [:request_id]

# Use Jason for JSON parsing in Phoenix
config :phoenix, :json_library, Jason

# Import environment specific config. This must remain at the bottom
# of this file so it overrides the configuration defined above.
import_config "#{config_env()}.exs"
