defmodule Op.Application do
  # See https://hexdocs.pm/elixir/Application.html
  # for more information on OTP Applications
  @moduledoc false

  use Application

  @impl true
  def start(_type, _args) do
    children = [
      OpWeb.Telemetry,
      Op.Repo,
      {Boltx, Application.get_env(:boltx, Bolt)},
      {DNSCluster, query: Application.get_env(:op, :dns_cluster_query) || :ignore},
      {Oban, Application.fetch_env!(:op, Oban)},
      {Phoenix.PubSub, name: Op.PubSub},
      # Start the Finch HTTP client for sending emails
      {Finch, name: Op.Finch},
      # Start a worker by calling: Op.Worker.start_link(arg)
      # {Op.Worker, arg},
      # Start to serve requests, typically the last entry
      OpWeb.Endpoint
    ]

    # See https://hexdocs.pm/elixir/Supervisor.html
    # for other strategies and supported options
    opts = [strategy: :one_for_one, name: Op.Supervisor]
    Supervisor.start_link(children, opts)
  end

  # Tell Phoenix to update the endpoint configuration
  # whenever the application is updated.
  @impl true
  def config_change(changed, _new, removed) do
    OpWeb.Endpoint.config_change(changed, removed)
    :ok
  end
end
