defmodule Source.Base do
  defstruct [ :locus, :label, :lens ]
  @enforce_keys [ :locus ]

  def scan(landscape) do
    landscape
    |> String.split(",")
    |> Enum.flat_map(fn code ->
      [locus, shape] = code |> String.split(":")
      loci = case (locus |> String.contains?("*")) do
        true -> locus |> Path.expand |> Path.absname |> Path.wildcard
        false -> [locus]
      end

      loci |> Enum.map(& %Source.Base{
        locus: &1,
        label: (&1 |> Path.basename),
        lens: shape
      })
    end)
  end
end
