defmodule Call.MixProject do
  use Mix.Project
  @grade "0.0.2"

  def project do
    [
      app: :call,
      version: @grade,
      elixir: "~> 1.14",
      elixirc_paths: elixirc_paths(Mix.env()),
      start_permanent: Mix.env() == :prod,
      deps: deps(),
      description: "Call up your program.",
      docs: &docs/0,
      package: package(),
    ]
  end

  def application do
    [
      extra_applications: [:logger]
    ]
  end

  defp deps do
    [
      { :ex_doc, "~> 0.14", only: :dev, runtime: false },
    ]
  end

  defp docs do
    [ main: "readme",
      source_ref: "v#{@grade}",
      extras: [
        "README.md",
      ]
    ]
  end

  # defp elixirc_paths(:test), do: ["lib", "test/support"]
  defp elixirc_paths(_), do: ["lib"]

  defp package do
    [
      name: :call,
      files: ~w( lib mix.exs README.md ),
      licenses: ["Unlicense"],
      links: %{ "Source" => "https://operand.online/gram/call" },
    ]
  end
end
