defmodule Oban.Web.Layouts do
  use Oban.Web, :html

  @static_path Application.app_dir(:oban_web, ["priv", "static"])

  @external_resource Path.join(@static_path, "app.css")
  @external_resource Path.join(@static_path, "app.js")

  @css @static_path
       |> Path.join("app.css")
       |> File.read!()

  @js @static_path
      |> Path.join("app.js")
      |> File.read!()

  def render("app.css"), do: @css
  def render("app.js"), do: @js

  embed_templates "layouts/*"

  def logo(assigns) do
    ~H"""
    <a href={oban_path(:jobs)} title="Oban Web">
      <svg class="h-10 overflow-visible" viewBox="0 0 227 64">
        <path
          class="text-violet-950 dark:text-violet-50"
          d="M177.701 45.727h.897l8.214-19.535h-3.542c-.392 0-1.358.13-1.877 1.331-.32.741-3.991 9.734-3.991 9.735l-.2.472-1.945-4.666 2.889-6.87h-3.543c-.392 0-1.36.13-1.876 1.33-.32.742-3.992 9.736-3.992 9.736l-.2.471c-.06-.152-3.964-9.499-4.278-10.264-.327-.798-1.018-1.275-1.847-1.275l-3.535.002 7.459 17.747a2.923 2.923 0 0 0 2.699 1.79h.897l2.913-6.928 2.16 5.136a2.922 2.922 0 0 0 2.698 1.791v-.003Zm22.205-.208c.935-.31 1.82-.749 2.635-1.307.195-.138.393-.3.596-.48l.441-.395-.358-.47c-.987-1.314-1.977-1.951-3.025-1.951-.546 0-1.002.169-1.366.302l-.283.101a5.776 5.776 0 0 1-1.755.267 5.39 5.39 0 0 1-2.013-.377 5.66 5.66 0 0 1-1.696-1.052 5.36 5.36 0 0 1-1.425-2.124h11.778c.531 0 1-.103 1.385-.299.312-.152 1.037-.641 1.037-1.85a9.928 9.928 0 0 0-.74-3.829 9.753 9.753 0 0 0-2.007-3.073 9.285 9.285 0 0 0-2.968-2.055 8.937 8.937 0 0 0-3.64-.754 9.19 9.19 0 0 0-3.765.787 9.754 9.754 0 0 0-3.046 2.13 10.154 10.154 0 0 0-2.053 3.149 9.947 9.947 0 0 0-.76 3.863c0 1.362.262 2.664.78 3.869a9.902 9.902 0 0 0 2.126 3.137c.897.89 1.96 1.601 3.158 2.11a9.85 9.85 0 0 0 3.88.782 9.758 9.758 0 0 0 3.084-.48Zm-1.647-14.568a5.161 5.161 0 0 1 1.53.978c.446.413.815.906 1.097 1.467.064.127.123.256.177.388l-9.293.003c.056-.12.117-.238.185-.349.402-.672.776-1.154 1.177-1.518a5.27 5.27 0 0 1 1.555-.974 4.715 4.715 0 0 1 1.798-.342c.624 0 1.222.116 1.774.347Zm23.28 14.251a9.356 9.356 0 0 0 2.926-2.132 9.899 9.899 0 0 0 1.955-3.136c.468-1.197.705-2.49.705-3.85 0-1.348-.238-2.638-.707-3.83a10.037 10.037 0 0 0-1.95-3.144 9.304 9.304 0 0 0-2.93-2.14 8.516 8.516 0 0 0-3.65-.8c-.9 0-1.75.124-2.523.366a7.538 7.538 0 0 0-2.087 1.01 8.906 8.906 0 0 0-.27.199V18h-4.54v27.728h4.54v-1.042a8.679 8.679 0 0 0 1.922.89c.842.28 1.838.424 2.96.424a8.565 8.565 0 0 0 3.65-.798Zm-1.973-14.16c.591.282 1.115.67 1.556 1.158.45.492.808 1.082 1.07 1.75.263.671.395 1.393.395 2.152 0 .759-.132 1.481-.394 2.152a5.63 5.63 0 0 1-1.073 1.754 4.98 4.98 0 0 1-1.554 1.154 4.169 4.169 0 0 1-1.811.407 4.181 4.181 0 0 1-1.814-.407A5.058 5.058 0 0 1 214.373 40a5.671 5.671 0 0 1-1.085-1.754 5.762 5.762 0 0 1-.4-2.144c0-.755.134-1.476.4-2.141a5.642 5.642 0 0 1 1.087-1.758 5.09 5.09 0 0 1 1.568-1.16 4.169 4.169 0 0 1 1.812-.407c.637 0 1.246.136 1.811.406Zm-127.16 1.602a9.734 9.734 0 0 0-2.052-3.064 9.657 9.657 0 0 0-3.054-2.057 9.436 9.436 0 0 0-3.74-.752c-1.32 0-2.576.252-3.73.754a9.549 9.549 0 0 0-3.037 2.057 9.812 9.812 0 0 0-2.043 3.062 9.483 9.483 0 0 0-.75 3.75c0 1.322.251 2.58.75 3.744a9.833 9.833 0 0 0 2.043 3.052 9.523 9.523 0 0 0 3.036 2.056c1.157.5 2.411.754 3.732.754a9.407 9.407 0 0 0 3.74-.752 9.67 9.67 0 0 0 3.053-2.058 9.742 9.742 0 0 0 2.053-3.052 9.469 9.469 0 0 0 .75-3.744 9.526 9.526 0 0 0-.752-3.75Zm-2.44 6.43a7.34 7.34 0 0 1-1.494 2.206 6.957 6.957 0 0 1-2.204 1.493c-.84.36-1.74.542-2.675.542-.95 0-1.853-.182-2.683-.542a6.94 6.94 0 0 1-2.196-1.495 7.353 7.353 0 0 1-1.494-2.204 6.64 6.64 0 0 1-.549-2.68c0-.95.184-1.857.549-2.698a7.174 7.174 0 0 1 1.492-2.214 7.17 7.17 0 0 1 2.198-1.494 6.657 6.657 0 0 1 2.681-.55c.935 0 1.834.186 2.673.55a7.223 7.223 0 0 1 2.207 1.494 7.208 7.208 0 0 1 1.492 2.214c.365.84.55 1.75.55 2.698a6.583 6.583 0 0 1-.547 2.68Zm23.054-6.43a9.78 9.78 0 0 0-1.883-3.053 8.952 8.952 0 0 0-2.809-2.064 8.088 8.088 0 0 0-3.461-.756c-.859 0-1.663.114-2.39.342a6.993 6.993 0 0 0-1.947.945c-.486.34-.928.737-1.313 1.177l-.604.689V18h-2.785v27.693h2.785v-2.275l.578.54c.241.226.516.446.824.658.55.38 1.225.706 2.012.972.794.264 1.749.397 2.838.397a8.06 8.06 0 0 0 3.463-.76 9.007 9.007 0 0 0 2.807-2.05 9.655 9.655 0 0 0 1.886-3.044 10.27 10.27 0 0 0 .682-3.752 10.247 10.247 0 0 0-.683-3.735Zm-2.594 6.434a7.092 7.092 0 0 1-1.344 2.204 6.376 6.376 0 0 1-1.98 1.477 5.476 5.476 0 0 1-2.381.538c-.839 0-1.64-.18-2.382-.538a6.49 6.49 0 0 1-1.993-1.479 7.276 7.276 0 0 1-1.862-4.886c0-.94.168-1.843.5-2.684a7.122 7.122 0 0 1 1.362-2.2 6.458 6.458 0 0 1 1.991-1.48 5.47 5.47 0 0 1 2.382-.54 5.44 5.44 0 0 1 2.38.54c.754.36 1.422.859 1.98 1.478a7.066 7.066 0 0 1 1.345 2.202 7.39 7.39 0 0 1 .492 2.684c0 .943-.163 1.845-.49 2.684Zm20.508-12.263-.019 2.926-.592-.646a6.62 6.62 0 0 0-1.296-1.09 7.626 7.626 0 0 0-2.034-.912 8.492 8.492 0 0 0-2.363-.322c-1.287 0-2.496.254-3.594.756a8.868 8.868 0 0 0-2.865 2.072 9.741 9.741 0 0 0-1.893 3.07 10.263 10.263 0 0 0-.684 3.744c0 1.322.233 2.576.694 3.731a9.582 9.582 0 0 0 1.902 3.044 8.963 8.963 0 0 0 2.865 2.056c1.098.5 2.301.756 3.577.756a8.69 8.69 0 0 0 2.315-.302 7.397 7.397 0 0 0 1.998-.875 6.594 6.594 0 0 0 1.32-1.11l.6-.673v.903c0 .46 0 1.65 2.73 1.743V29.822a3.034 3.034 0 0 0-2.66-3.007Zm-.554 12.311a6.791 6.791 0 0 1-1.29 2.176 6.01 6.01 0 0 1-1.966 1.448c-.756.35-1.596.53-2.494.53a5.915 5.915 0 0 1-2.522-.539 6.28 6.28 0 0 1-1.994-1.468 6.797 6.797 0 0 1-1.315-2.183 7.542 7.542 0 0 1-.475-2.679c0-.944.16-1.848.477-2.689.314-.839.753-1.58 1.308-2.202a6.232 6.232 0 0 1 1.986-1.484c.764-.363 1.618-.545 2.536-.545.908 0 1.75.182 2.508.543a6.15 6.15 0 0 1 1.967 1.495c.548.63.98 1.373 1.282 2.21.305.838.46 1.744.46 2.693a7.735 7.735 0 0 1-.468 2.694Zm21.802-7.585a7.704 7.704 0 0 0-1.58-2.495 7.555 7.555 0 0 0-2.396-1.68 7.305 7.305 0 0 0-2.994-.62c-.64 0-1.27.084-1.87.251a7.43 7.43 0 0 0-1.69.692c-.462.264-.894.58-1.283.938l-.577.53V26.79H137.1v18.9h2.693V34.386c.01-.698.152-1.331.43-1.939a5.076 5.076 0 0 1 1.118-1.579 5.196 5.196 0 0 1 3.583-1.436c.77 0 1.47.135 2.079.397.61.263 1.139.628 1.576 1.09.44.463.79 1.012 1.042 1.63.25.618.408 1.3.454 1.99V45.65l2.676-.016V34.596a8.256 8.256 0 0 0-.568-3.055Z"
          fill="currentColor"
          fill-rule="nonzero"
        />
        <g fill="none" fill-rule="evenodd" class="drop-shadow-md/30">
          <path fill="#EBECFB" d="M57.95 21.249 54.623 9.372 42.746 6.045l4.453 10.751z" /><path
            fill="#C5B0DF"
            d="m53.497 31.999-6.298-15.203 10.751 4.453z"
          /><path
            d="m54.625 9.37 3.327 11.876 3.608-1.494a32.03 32.03 0 0 0-6.934-10.376l-.001-.006Z"
            fill="#6C5080"
          /><path
            d="M61.56 19.752a32.032 32.032 0 0 1 2.437 12.244l-6.045-10.75 3.608-1.494Z"
            fill="#F0E9F8"
          /><path fill="#BBBAF0" d="m57.952 42.747 6.045-10.751-6.045-10.75-4.453 10.75z" /><path
            fill="#8561C9"
            d="m47.201 47.2 6.298-15.204 4.453 10.751z"
          /><path
            d="m64 31.996-6.045 10.75 3.608 1.495A32.03 32.03 0 0 0 63.997 32l.003-.005Z"
            fill="#2B1555"
          /><path
            d="M61.563 44.24a32.03 32.03 0 0 1-6.935 10.383l3.327-11.877 3.608 1.495Z"
            fill="#533E7E"
          /><path fill="#CBBEE9" d="m42.751 57.95 11.877-3.327 3.327-11.877-10.751 4.453z" /><path
            fill="#9D8CC9"
            d="m32.001 53.497 15.203-6.298-4.453 10.751z"
          /><path
            d="m54.63 54.625-11.876 3.327 1.495 3.608a32.03 32.03 0 0 0 10.375-6.934l.006-.001Z"
            fill="#7D60AF"
          /><path
            d="M44.249 61.56a32.032 32.032 0 0 1-12.245 2.437l10.75-6.045 1.495 3.608Z"
            fill="#5B488B"
          /><path fill="#8354B4" d="m21.253 57.952 10.751 6.045 10.75-6.045-10.75-4.453z" /><path
            fill="#7E6294"
            d="m16.8 47.201 15.204 6.298-10.751 4.453z"
          /><path
            d="m32.004 64-10.75-6.045-1.495 3.608A32.03 32.03 0 0 0 32 63.997l.005.003Z"
            fill="#9C87D5"
          /><path
            d="M19.76 61.563a32.03 32.03 0 0 1-10.383-6.935l11.877 3.327-1.495 3.608Z"
            fill="#4E2B7F"
          /><path fill="#A070C7" d="m6.05 42.751 3.327 11.877 11.877 3.327-4.453-10.751z" /><path
            fill="#DFB1F3"
            d="m10.503 32.001 6.298 15.203L6.05 42.751z"
          /><path
            d="M9.375 54.63 6.048 42.754 2.44 44.248a32.03 32.03 0 0 0 6.934 10.376l.001.006Z"
            fill="#1F0F46"
          /><path
            d="M2.44 44.248A32.031 32.031 0 0 1 .003 32.004l6.045 10.75-3.608 1.494Z"
            fill="#856CAD"
          /><path fill="#918EC3" d="M6.048 21.253.003 32.004l6.045 10.75 4.453-10.75z" /><path
            fill="#CBA3FC"
            d="m16.799 16.8-6.298 15.204-4.453-10.751z"
          /><path
            d="m0 32.004 6.045-10.75-3.608-1.495A32.03 32.03 0 0 0 .003 32L0 32.003Z"
            fill="#65516A"
          /><path
            d="M2.437 19.76A32.03 32.03 0 0 1 9.372 9.376L6.045 21.254l-3.608-1.495Z"
            fill="#CABBC3"
          /><path fill="#EADBFB" d="M21.249 6.05 9.372 9.377 6.045 21.254l10.751-4.453z" /><path
            fill="#B07BB7"
            d="m31.999 10.503-15.203 6.298L21.249 6.05z"
          /><path
            d="m9.37 9.375 11.876-3.327-1.494-3.608A32.03 32.03 0 0 0 9.376 9.374l-.006.001Z"
            fill="#AB83C5"
          /><path
            d="M19.752 2.44A32.031 32.031 0 0 1 31.996.003l-10.75 6.045-1.494-3.608Z"
            fill="#D89AF6"
          /><path fill="#F6F5FC" d="M42.747 6.048 31.996.003l-10.75 6.045 10.75 4.453z" /><path
            fill="#CAB5EB"
            d="m47.2 16.799-15.204-6.298 10.751-4.453z"
          /><path
            d="m31.996 0 10.75 6.045 1.495-3.608A32.03 32.03 0 0 0 32 .003L31.997 0Z"
            fill="#BAA4ED"
          /><path
            d="M44.24 2.437a32.031 32.031 0 0 1 10.383 6.935L42.746 6.045l1.495-3.608Z"
            fill="#9996D7"
          />
        </g>
      </svg>
    </a>
    """
  end

  def notify(assigns) do
    ~H"""
    <div
      id="notice"
      phx-remove={JS.hide(transition: "fade-out-scale", to: "#notice")}
      class="fixed z-40 inset-0 flex items-end justify-center pointer-events-none md:py-3 md:px-4 sm:p-6 sm:items-start sm:justify-end"
    >
      <div class="max-w-sm w-full bg-white dark:bg-black dark:bg-opacity-90 shadow-lg rounded-lg pointer-events-auto">
        <div class="rounded-lg ring-1 ring-black ring-opacity-5 overflow-hidden">
          <div class="p-4">
            <div class="flex items-start">
              <div class="flex-shrink-0 text-green-400">
                <Icons.check_circle />
              </div>
              <div class="ml-3 w-0 flex-1 pt-0.5">
                <p class="text-sm leading-5 font-medium text-gray-900 dark:text-gray-100">
                  {Phoenix.Flash.get(assigns.flash, :info)}
                </p>
              </div>
              <div class="ml-4 flex-shrink-0 flex">
                <button
                  phx-click="lv:clear-flash"
                  class="inline-flex text-gray-400 dark:text-gray-600 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 focus:text-gray-500 transition ease-in-out duration-150"
                >
                  <Icons.x_mark class="w-5 h-5" />
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    """
  end

  def nav(assigns) do
    ~H"""
    <nav class="flex space-x-2">
      <.link
        :for={page <- [:jobs, :queues]}
        class={link_class(@page, page)}
        data-shortcut={JS.navigate(oban_path(page))}
        id={"nav-#{page}"}
        navigate={oban_path(page)}
        title={"Navigate to #{String.capitalize(to_string(page))}"}
      >
        {String.capitalize(to_string(page))}
      </.link>
    </nav>
    """
  end

  def footer(assigns) do
    assigns =
      assign(assigns,
        oss_version: Application.spec(:oban, :vsn),
        met_version: Application.spec(:oban_met, :vsn),
        web_version: Application.spec(:oban_web, :vsn),
        pro_version: Application.spec(:oban_pro, :vsn)
      )

    ~H"""
    <footer class="flex flex-col px-3 py-6 text-sm justify-center items-center md:flex-row">
      <.version name="Oban" version={@oss_version} />
      <.version name="Oban.Web" version={@web_version} />
      <.version name="Oban.Met" version={@met_version} />
      <.version name="Oban.Pro" version={@pro_version} />

      <span class="text-gray-800 dark:text-gray-200 mr-0.5 pt-1">
        <Icons.soren_logo />
      </span>

      <span class="text-gray-800 dark:text-gray-200 font-semibold">Made by Soren</span>
    </footer>
    """
  end

  attr :name, :string
  attr :version, :string

  defp version(assigns) do
    ~H"""
    <span class="text-gray-600 dark:text-gray-400 tabular mr-0 mb-1 md:mr-3 md:mb-0">
      {@name} {if @version, do: "v#{@version}", else: "–"}
    </span>
    """
  end

  defp link_class(curr, page) do
    base = "font-semibold text-sm rounded-md px-3 py-2"

    if curr == page do
      base <> " text-gray-950 dark:text-gray-100 bg-gray-50 dark:bg-gray-800"
    else
      base <> " text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-gray-100"
    end
  end
end
