defmodule Rewrite.Hook.DotFormatterUpdater do
  @moduledoc """
  A hook that updates the dot-formatter for a `%Rewrite{}` project on changes.
  """

  alias Rewrite.DotFormatter

  @behaviour Rewrite.Hook

  @formatter ".formatter.exs"

  @impl true
  def handle(:new, project) do
    {:ok, %{project | dot_formatter: dot_formatter(project)}}
  end

  def handle({action, files}, project) when action in [:added, :updated] do
    if dot_formatter?(files) do
      {:ok, %{project | dot_formatter: dot_formatter(project)}}
    else
      :ok
    end
  end

  defp dot_formatter(project) do
    case DotFormatter.read(project) do
      {:ok, dot_formatter} -> dot_formatter
      {:error, _error} -> DotFormatter.default()
    end
  end

  defp dot_formatter?(@formatter), do: true
  defp dot_formatter?(files) when is_list(files), do: Enum.member?(files, @formatter)
  defp dot_formatter?(_files), do: false
end
