defmodule Splash do
  def splashes do
    System.get_env("PAGE_BASE")
    |> Source.measure("splash.md")
    |> String.trim
    |> String.split("\n")
    |> Enum.map(&String.trim/1)
    |> Enum.reject(& &1 =~ ~r/^#/ )
  end

  def random do
    splashes() |> Enum.random
  end

  def hourly do
    s = splashes()
    c = DateTime.utc_now |> DateTime.truncate(:second)
    {:ok, dura } = (
      c |> Tox.DateTime.beginning_of_year
      |> Tox.Interval.new(Tox.Period.new!(year: 1)))
    {:ok, seconds } = dura |> Tox.Interval.since_start(c)
    hour = (seconds / 3600) |> round()
    s |> Enum.at(hour |> Integer.mod(s |> length))
  end
end
