defmodule OpWeb.Chronicle.Show do
  alias Phoenix.LiveView.JS

  use OpWeb, :live_view
    import Phoenix.HTML
    import Phoenix.HTML.Form
    use PhoenixHTMLHelpers

  @impl true
  def mount(_params, _session, socket) do
    {:ok, socket}
  end

  @impl true
  def handle_params(%{"key" => key } = params, _, socket) do
    page = Source.Page.query_by_key!(key)
    linebreaks = (page.linebreaks || params["l"] == "b")
    body = if linebreaks do
      page.body |> String.split("\n") |> Enum.join("  \n")
    else
      page.body
    end

    {:noreply,
      socket
      |> assign(:page_title, key <> " | Chronicle")
      |> assign(:page, page)
      |> assign(:body, body)
      |> assign(:linebreaks, linebreaks)
    }
  end
end
