defmodule OpWeb.Gram.Node do
  use OpWeb, :live_view
  # Oh no; seems a simple `Path.extname` scan is a really unreliable means
  # of applying lenses here; some common node names break such a procedure:
  # - .gitignore
  # - Cargo.lock, flake.lock, Gemfile.lock
  # - Procfile
  # each one is a special case and needs pre-recognicion,
  # so lenses can be assigned more precisely.
  @lenses %{
    # "md" => ~w[ a b c ],
  }

  @impl true
  def mount(_params, _session, socket) do
    # (socket |> get_connect_params)["colorscheme"] |> IO.inspect
    {:ok, socket}
  end

  @impl true
  def handle_params(%{"base" => base, "address" => address}, _, socket) do
    "." <> lang = address |> Path.extname
    {:noreply,
      socket
      |> assign(:page_title, "gram:" <> base <> " | Operand")
      |> assign(:base, System.get_env("GRAM_BASE") <> base)
      |> assign(:address, address |> Enum.join("/"))
      |> assign(:lang, lang)
    }
  end
end
