defmodule OpWeb.Router do
  use OpWeb, :router

  pipeline :browser do
    plug :accepts, ["html"]
    plug :fetch_session
    plug :fetch_live_flash
    plug :put_root_layout, html: {OpWeb.Layouts, :root}
    plug :protect_from_forgery
    plug :put_secure_browser_headers
  end

  pipeline :secure do
    import Plug.BasicAuth
    plug :basic_auth,
      username: System.fetch_env!("SUPER_USER"),
      password: System.fetch_env!("SUPER_PASS")
  end

  pipeline :api do
    plug :accepts, ["json"]
  end

  scope "/", OpWeb do
    pipe_through :browser
    live "/", Domain.Index, :index, as: :domain
    get "/rss", RssController, :index
  end

  scope "/gram", OpWeb do
    pipe_through :browser
    live "/:base", Gram.Base, :index, as: :gram
    live "/:base/*address", Gram.Node, :node, as: :gram
  end

  scope "/chronicle", OpWeb do
    pipe_through :browser
    get "/", Course, to: "/"
    live "/:key", Chronicle.Show, :show, as: :chronicle
  end

  scope "/page", OpWeb do
    pipe_through :browser
    get "/", PageController, :index
    get "/:key", PageController, :show
  end

  # Other scopes may use custom stacks.
  # scope "/api", OpWeb do
  #   pipe_through :api
  # end

  scope "/dash" do
    import Phoenix.LiveDashboard.Router

    pipe_through :browser
    if Mix.env == :prod do
      pipe_through :secure
    # else
      # forward "/mailbox", Plug.Swoosh.MailboxPreview
    end

    live_dashboard "/board", metrics: OpWeb.Telemetry
  end
end
