defmodule OpWeb.RssXML do
  use OpWeb, :xml
  embed_templates "rss_xml/*", ext: ".xml"

  def pub_date(nil), do: ""
  def pub_date(pages) when is_list(pages), do: List.first(pages) |> pub_date()
  def pub_date(page), do: page.day |> Date.from_iso8601() |> elem(1) |> format_rfc822()

  def format_rfc822(date_time), do: Calendar.strftime(date_time, "%a, %d %b %Y 00:00:00 %Z")
  # def format_rfc822(date_time), do: Calendar.strftime(date_time, "%a, %d %b %Y %H:%M:%S %Z")
end
