defmodule OpWeb.Domain.Index do
  use OpWeb, :live_view
  import Phoenix.HTML
  import Phoenix.HTML.Form
  use PhoenixHTMLHelpers

  @impl true
  def mount(_params, _session, socket) do
    {:ok, socket
    |> stream_configure(:chronicles, dom_id: &("chronicle-#{&1.day}.#{&1.key}"))
    |> stream(:chronicles, Source.Page.query())
    }
  end

  @impl true
  def handle_params(params, _url, socket) do
    {:noreply, apply_action(socket, socket.assigns.live_action, params)}
  end

  defp apply_action(socket, :index, _params) do
    socket
    |> assign(:page_title, "Chronicles")
    |> assign(:chronicle, nil)
  end

  defp domains do
    [
      comms: "msg",
      code: "share",
      designs: "paper",
      research: "page",
      signal: "pulse",
      audience: "session",
      books: "library",
      inbox: "mail",
      passcodes: "padloc",
    ]
  end

  def relay(closure \\ nil) do
    cmd = case closure do
      nil -> "relay describe"
      c -> "relay describe { #{closure} }"
    end
    System.cmd("nu", ["-c",
      "source ~/.config/nushell/relay.nu; #{cmd}"
    ]) |> elem(0) |> String.trim
  end
end
