defmodule Op.Repo.Migrations.CommuniqueMessages do
  @moduledoc """
  Updates resources based on their most recent snapshots.

  This file was autogenerated with `mix ash_postgres.generate_migrations`
  """

  use Ecto.Migration

  def up do
    create table(:messages, primary_key: false) do
      add :key, :uuid, null: false, default: fragment("gen_random_uuid()"), primary_key: true
      add :handle, :text, null: false
      add :email, :text, null: false
      add :body, :text, null: false
      add :published, :utc_datetime

      add :inserted_at, :utc_datetime_usec,
        null: false,
        default: fragment("(now() AT TIME ZONE 'utc')")

      add :updated_at, :utc_datetime_usec,
        null: false,
        default: fragment("(now() AT TIME ZONE 'utc')")
    end
  end

  def down do
    drop table(:messages)
  end
end
