defmodule OpWeb.QueriLiveTest do
  use OpWeb.ConnCase

  import Phoenix.LiveViewTest
  import Op.BaseFixtures

  @create_attrs %{code: "some code", label: "some label", signed: "some signed", cache: "some cache", source: "some source", lang: "some lang", applies: "2024-02-05T17:54:00Z", expires: "2024-02-05T17:54:00Z", chronology: "some chronology"}
  @update_attrs %{code: "some updated code", label: "some updated label", signed: "some updated signed", cache: "some updated cache", source: "some updated source", lang: "some updated lang", applies: "2024-02-06T17:54:00Z", expires: "2024-02-06T17:54:00Z", chronology: "some updated chronology"}
  @invalid_attrs %{code: nil, label: nil, signed: nil, cache: nil, source: nil, lang: nil, applies: nil, expires: nil, chronology: nil}

  defp create_queri(_) do
    queri = queri_fixture()
    %{queri: queri}
  end

  describe "Index" do
    setup [:create_queri]

    test "lists all queries", %{conn: conn, queri: queri} do
      {:ok, _index_live, html} = live(conn, ~p"/queri")

      assert html =~ "Listing Queries"
      assert html =~ queri.code
    end

    test "saves new queri", %{conn: conn} do
      {:ok, index_live, _html} = live(conn, ~p"/queri")

      assert index_live |> element("a", "New Queri") |> render_click() =~
               "New Queri"

      assert_patch(index_live, ~p"/queri/new")

      assert index_live
             |> form("#queri-form", queri: @invalid_attrs)
             |> render_change() =~ "can&#39;t be blank"

      assert index_live
             |> form("#queri-form", queri: @create_attrs)
             |> render_submit()

      assert_patch(index_live, ~p"/queri")

      html = render(index_live)
      assert html =~ "Queri created successfully"
      assert html =~ "some code"
    end

    test "updates queri in listing", %{conn: conn, queri: queri} do
      {:ok, index_live, _html} = live(conn, ~p"/queri")

      assert index_live |> element("#queries-#{queri.id} a", "Edit") |> render_click() =~
               "Edit Queri"

      assert_patch(index_live, ~p"/queri/#{queri}/edit")

      assert index_live
             |> form("#queri-form", queri: @invalid_attrs)
             |> render_change() =~ "can&#39;t be blank"

      assert index_live
             |> form("#queri-form", queri: @update_attrs)
             |> render_submit()

      assert_patch(index_live, ~p"/queri")

      html = render(index_live)
      assert html =~ "Queri updated successfully"
      assert html =~ "some updated code"
    end

    test "deletes queri in listing", %{conn: conn, queri: queri} do
      {:ok, index_live, _html} = live(conn, ~p"/queri")

      assert index_live |> element("#queries-#{queri.id} a", "Delete") |> render_click()
      refute has_element?(index_live, "#queries-#{queri.id}")
    end
  end

  describe "Show" do
    setup [:create_queri]

    test "displays queri", %{conn: conn, queri: queri} do
      {:ok, _show_live, html} = live(conn, ~p"/queri/#{queri}")

      assert html =~ "Show Queri"
      assert html =~ queri.code
    end

    test "updates queri within modal", %{conn: conn, queri: queri} do
      {:ok, show_live, _html} = live(conn, ~p"/queri/#{queri}")

      assert show_live |> element("a", "Edit") |> render_click() =~
               "Edit Queri"

      assert_patch(show_live, ~p"/queri/#{queri}/show/edit")

      assert show_live
             |> form("#queri-form", queri: @invalid_attrs)
             |> render_change() =~ "can&#39;t be blank"

      assert show_live
             |> form("#queri-form", queri: @update_attrs)
             |> render_submit()

      assert_patch(show_live, ~p"/queri/#{queri}")

      html = render(show_live)
      assert html =~ "Queri updated successfully"
      assert html =~ "some updated code"
    end
  end
end
