defmodule Op.BaseFixtures do
  @moduledoc """
  This module defines test helpers for creating
  entities via the `Op.Base` context.
  """

  @doc """
  Generate a queri.
  """
  def queri_fixture(attrs \\ %{}) do
    {:ok, queri} =
      attrs
      |> Enum.into(%{
        applies: ~U[2024-02-05 17:54:00Z],
        cache: "some cache",
        chronology: "some chronology",
        code: "some code",
        expires: ~U[2024-02-05 17:54:00Z],
        label: "some label",
        lang: "some lang",
        signed: "some signed",
        source: "some source"
      })
      |> Op.Base.create_queri()

    queri
  end
end
