{ inputs.nixpkgs.url = "github:nixos/nixpkgs/nixos-unstable";
outputs = { nixpkgs, ... }: let
  arch = "x86_64-linux";
  pkgs = import nixpkgs { system = arch; };
in with pkgs; {
  packages.${arch} = { default = elixir; };
  devShells.${arch}.default = mkShell {
    shellHook = "set -a; source .call; set +a;";
    packages = [
      elixir bun tailwindcss_4
      git libgit2 nushell
      gnupg openssl inotify-tools
    ];
    BUN = "${bun}/bin/bun";
    TAILWIND = "${tailwindcss_4}/bin/tailwindcss";
}; }; }
