// node_modules/marko/dist/debug/dom.mjs
var empty = [];
var rest = true ? Symbol("Attribute Tag") : Symbol();
function attrTag(attrs2) {
  attrs2[Symbol.iterator] = attrTagIterator;
  attrs2[rest] = empty;
  return attrs2;
}
function attrTags(first, attrs2) {
  if (first) {
    if (first[rest] === empty) {
      first[rest] = [attrs2];
    } else {
      first[rest].push(attrs2);
    }
    return first;
  }
  return attrTag(attrs2);
}
function* attrTagIterator() {
  yield this;
  yield* this[rest];
}
function forIn(obj, cb) {
  for (const key in obj) {
    cb(key, obj[key]);
  }
}
function forOf(list, cb) {
  if (list) {
    let i = 0;
    for (const item of list) {
      cb(item, i++);
    }
  }
}
function forTo(to, from, step, cb) {
  const start = from || 0;
  const delta = step || 1;
  for (let steps = (to - start) / delta, i = 0; i <= steps; i++) {
    cb(start + i * delta);
  }
}
function classValue(classValue2) {
  return toDelimitedString(classValue2, " ", stringifyClassObject);
}
function stringifyClassObject(name, value2) {
  return value2 ? name : "";
}
function styleValue(styleValue2) {
  return toDelimitedString(styleValue2, ";", stringifyStyleObject);
}
function stringifyStyleObject(name, value2) {
  return value2 || value2 === 0 ? name + ":" + value2 : "";
}
function toDelimitedString(val, delimiter, stringify) {
  let str = "";
  let sep = "";
  let part;
  if (val) {
    if (typeof val !== "object") {
      str += val;
    } else if (Array.isArray(val)) {
      for (const v of val) {
        part = toDelimitedString(v, delimiter, stringify);
        if (part) {
          str += sep + part;
          sep = delimiter;
        }
      }
    } else {
      for (const name in val) {
        part = stringify(name, val[name]);
        if (part) {
          str += sep + part;
          sep = delimiter;
        }
      }
    }
  }
  return str;
}
function isEventHandler(name) {
  return /^on[A-Z-]/.test(name);
}
function getEventHandlerName(name) {
  return name[2] === "-" ? name.slice(3) : name.slice(2).toLowerCase();
}
function normalizeDynamicRenderer(value2) {
  return value2 ? value2.content || value2.default || value2 : void 0;
}
var defaultDelegator = createDelegator();
function on(element, type, handler) {
  if (element["$" + type] === void 0) {
    defaultDelegator(element, type, handleDelegated);
  }
  element["$" + type] = handler || null;
}
function createDelegator() {
  const kEvents = Symbol();
  return function ensureDelegated(node, type, handler) {
    ((node = node.getRootNode())[kEvents] ||= {})[type] ||= (node.addEventListener(type, handler, true), 1);
  };
}
function handleDelegated(ev) {
  let target = !rendering && ev.target;
  while (target) {
    target["$" + ev.type]?.(ev, target);
    target = ev.bubbles && !ev.cancelBubble && target.parentNode;
  }
}
function resolveCursorPosition(inputType2, initialPosition, initialValue, updatedValue) {
  if (
    // If initial position is null or false then
    // either this node is not the active element
    // or does not support selection ranges.
    (initialPosition || initialPosition === 0) && (initialPosition !== initialValue.length || // short regex to match input types that delete backwards
    /kw/.test(inputType2))
  ) {
    const before = initialValue.slice(0, initialPosition);
    const after = initialValue.slice(initialPosition);
    if (updatedValue.startsWith(before)) {
      return initialPosition;
    } else if (updatedValue.endsWith(after)) {
      return updatedValue.length - after.length;
    } else {
      const relevantChars = stripSpacesAndPunctuation(before).length;
      let pos = 0;
      let relevantIndex = 0;
      while (relevantIndex < relevantChars) {
        if (stripSpacesAndPunctuation(updatedValue[pos])) relevantIndex++;
        pos++;
      }
      return pos;
    }
  }
  return -1;
}
function stripSpacesAndPunctuation(str) {
  return str.replace(/[^\p{L}\p{N}]/gu, "");
}
var DEFAULT_RUNTIME_ID = "M";
var DEFAULT_RENDER_ID = "_";
var registeredValues = {};
var branchesEnabled;
function enableBranches() {
  branchesEnabled = 1;
}
function init(runtimeId = DEFAULT_RUNTIME_ID) {
  if (true) {
    if (!runtimeId.match(/^[_$a-z][_$a-z0-9]*$/i)) {
      throw new Error(
        `Invalid runtimeId: "${runtimeId}". The runtimeId must be a valid JavaScript identifier.`
      );
    }
    const descriptor = Object.getOwnPropertyDescriptor(self, runtimeId);
    if (descriptor && (descriptor.set || descriptor.configurable === false)) {
      throw new Error(
        `Marko initialized multiple times with the same $global.runtimeId of ${JSON.stringify(runtimeId)}. It could be that there are multiple copies of Marko running on the page.`
      );
    }
  }
  const renders = self[runtimeId];
  const defineRuntime = (desc) => Object.defineProperty(self, runtimeId, desc);
  let resumeRender;
  const initRuntime = (renders2) => {
    defineRuntime({
      value: resumeRender = (renderId) => {
        const render = resumeRender[renderId] = renders2[renderId] || renders2(renderId);
        const walk2 = render.w;
        const commentPrefixLen = render.i.length;
        const scopeLookup = render.s = {};
        const serializeContext = {
          _: registeredValues
        };
        const branches = branchesEnabled && /* @__PURE__ */ (() => {
          const branchStack = [];
          const branchIds = /* @__PURE__ */ new Set();
          const parentBranchIds = /* @__PURE__ */ new Map();
          let lastEndNode;
          let currentBranchId;
          const endBranch = (branchId, reference) => {
            const branch = scopeLookup[branchId] ||= {};
            let endNode = reference;
            let prevNode;
            while ((prevNode = endNode.previousSibling) !== branch.___startNode && ~visits.indexOf(endNode = prevNode)) ;
            branch.___endNode = lastEndNode = endNode === lastEndNode ? reference.parentNode.insertBefore(new Text(), reference) : endNode;
            branch.___startNode ||= lastEndNode;
            branchIds.add(branchId);
            return branch;
          };
          return {
            ___visit() {
              if (visitToken === "[") {
                if (currentBranchId && visitDataIndex) {
                  endBranch(currentBranchId, visit);
                  currentBranchId = branchStack.pop();
                }
                if (currentBranchId) {
                  branchStack.push(currentBranchId);
                  parentBranchIds.set(scopeId, currentBranchId);
                }
                currentBranchId = scopeId;
                visitScope.___startNode = visit;
              } else if (visitToken === "]") {
                const curParent = visit.parentNode;
                const startNode = endBranch(
                  currentBranchId,
                  visit
                ).___startNode;
                visitScope[visitData] = visit;
                if (curParent !== startNode.parentNode) {
                  curParent.prepend(startNode);
                }
                currentBranchId = branchStack.pop();
              } else {
                let next = visitData.indexOf(" ");
                let curNode = visit;
                visitScope[~next ? visitData.slice(0, next) : visitData] = visitToken === "=" ? visit.parentNode : visit;
                while (~next) {
                  const start = next + 1;
                  next = visitData.indexOf(" ", start);
                  const childScopeId = +visitData.slice(
                    start,
                    ~next ? next : visitData.length
                  );
                  curNode = endBranch(childScopeId, curNode).___endNode;
                  parentBranchIds.set(childScopeId, scopeId);
                }
              }
            },
            ___scope(scope) {
              const parentBranchId = scope[
                "#ClosestBranchId"
                /* ClosestBranchId */
              ] || parentBranchIds.get(scopeId);
              if (parentBranchId) {
                scope.___closestBranch = scopeLookup[parentBranchId];
              }
              if (branchIds.has(scopeId)) {
                const branch = scope;
                const parentBranch = branch.___closestBranch;
                scope.___closestBranch = branch;
                if (parentBranch) {
                  branch.___parentBranch = parentBranch;
                  (parentBranch.___branchScopes ||= /* @__PURE__ */ new Set()).add(branch);
                }
              }
            }
          };
        })();
        let $global;
        let lastScopeId = 0;
        let lastEffect;
        let visits;
        let resumes;
        let scopeId;
        let visit;
        let visitText;
        let visitData;
        let visitDataIndex;
        let visitToken;
        let visitScope;
        render.w = () => {
          try {
            walk2();
            isResuming = 1;
            for (visit of visits = render.v) {
              visitText = visit.data;
              visitDataIndex = visitText.indexOf(" ") + 1;
              scopeId = +visitText.slice(
                commentPrefixLen + 1,
                visitDataIndex ? visitDataIndex - 1 : visitText.length
              );
              visitData = visitDataIndex ? visitText.slice(visitDataIndex) : "";
              visitToken = visitText[commentPrefixLen];
              visitScope = scopeLookup[scopeId] ||= {
                ___id: scopeId
              };
              if (visitToken === "*") {
                visitScope["Getter:" + visitData] = /* @__PURE__ */ ((node) => () => node)(visitScope[visitData] = visit.previousSibling);
              } else if (branches) {
                branches.___visit();
              }
            }
            for (const serialized of resumes = render.r || []) {
              if (typeof serialized === "string") {
                lastEffect = serialized;
              } else if (typeof serialized === "number") {
                registeredValues[lastEffect](
                  scopeLookup[serialized] ||= {
                    ___id: scopeId
                  },
                  scopeLookup[serialized]
                );
              } else {
                for (const scope of serialized(serializeContext)) {
                  if (!$global) {
                    $global = scope || {};
                    $global.runtimeId = runtimeId;
                    $global.renderId = renderId;
                    $global.___nextScopeId = 1e6;
                  } else if (typeof scope === "number") {
                    lastScopeId += scope;
                  } else {
                    scopeId = ++lastScopeId;
                    scope.$global = $global;
                    scope.___id = scopeId;
                    if (scopeLookup[scopeId] !== scope) {
                      scopeLookup[scopeId] = Object.assign(
                        scope,
                        scopeLookup[scopeId]
                      );
                    }
                    if (branches) {
                      branches.___scope(scope);
                    }
                    if (true) {
                      scope.___debugId = "server-" + scopeId;
                    }
                  }
                }
              }
            }
          } finally {
            isResuming = visits.length = resumes.length = 0;
          }
        };
        return render;
      }
    });
  };
  if (renders) {
    initRuntime(renders);
    for (const renderId in renders) {
      resumeRender(renderId).w();
    }
  } else {
    defineRuntime({
      configurable: true,
      set: initRuntime
    });
  }
}
var isResuming;
function register(id, obj) {
  registeredValues[id] = obj;
  return obj;
}
function registerBoundSignal(id, signal) {
  registeredValues[id] = (scope) => (value2) => signal(scope, value2);
  return signal;
}
function getRegisteredWithScope(id, scope) {
  const val = registeredValues[id];
  return scope ? val(scope) : val;
}
function nodeRef(id, key) {
  return register(id, (scope) => () => scope[key]());
}
function controllable_input_checked(scope, nodeAccessor, checked, checkedChange) {
  setCheckboxValue(
    scope,
    nodeAccessor,
    0,
    normalizeBoolProp(checked),
    checkedChange
  );
}
function controllable_input_checked_effect(scope, nodeAccessor) {
  const el = scope[nodeAccessor];
  syncControllable(el, "input", hasCheckboxChanged, () => {
    const checkedChange = scope["ControlledHandler:" + nodeAccessor];
    if (checkedChange) {
      const newValue = el.checked;
      el.checked = !newValue;
      checkedChange(newValue);
      run();
    }
  });
}
function controllable_input_checkedValue(scope, nodeAccessor, checkedValue, checkedValueChange, value2) {
  scope["ControlledValue:" + nodeAccessor] = checkedValue;
  attr(scope[nodeAccessor], "value", value2);
  setCheckboxValue(
    scope,
    nodeAccessor,
    1,
    Array.isArray(checkedValue) ? checkedValue.includes(value2) : checkedValue === value2,
    checkedValueChange
  );
}
function controllable_input_checkedValue_effect(scope, nodeAccessor) {
  const el = scope[nodeAccessor];
  syncControllable(el, "input", hasCheckboxChanged, () => {
    const checkedValueChange = scope["ControlledHandler:" + nodeAccessor];
    if (checkedValueChange) {
      const oldValue = scope["ControlledValue:" + nodeAccessor];
      const newValue = Array.isArray(oldValue) ? updateList(oldValue, el.value, el.checked) : el.checked ? el.value : void 0;
      if (el.name && el.type[0] === "r") {
        for (const radio of el.getRootNode().querySelectorAll(
          `[type=radio][name=${CSS.escape(el.name)}]`
        )) {
          if (radio.form === el.form) {
            radio.checked = Array.isArray(oldValue) ? oldValue.includes(radio.value) : oldValue === radio.value;
          }
        }
      } else {
        el.checked = !el.checked;
      }
      checkedValueChange(newValue);
      run();
    }
  });
}
function controllable_input_value(scope, nodeAccessor, value2, valueChange) {
  const el = scope[nodeAccessor];
  const normalizedValue = normalizeStrProp(value2);
  scope["ControlledHandler:" + nodeAccessor] = valueChange;
  if (valueChange) {
    scope["ControlledType:" + nodeAccessor] = 0;
    scope["ControlledValue:" + nodeAccessor] = value2;
    if (el.isConnected) {
      setValueAndUpdateSelection(el, normalizedValue);
    } else {
      el.defaultValue = normalizedValue;
    }
  } else {
    scope["ControlledType:" + nodeAccessor] = 5;
    el.defaultValue = normalizedValue;
  }
}
function controllable_input_value_effect(scope, nodeAccessor) {
  const el = scope[nodeAccessor];
  if (isResuming) {
    scope["ControlledValue:" + nodeAccessor] = el.defaultValue;
  }
  syncControllable(el, "input", hasValueChanged, (ev) => {
    const valueChange = scope["ControlledHandler:" + nodeAccessor];
    if (valueChange) {
      inputType = ev?.inputType;
      valueChange(el.value);
      run();
      setValueAndUpdateSelection(
        el,
        scope["ControlledValue:" + nodeAccessor]
      );
      inputType = "";
    }
  });
}
function controllable_select_value(scope, nodeAccessor, value2, valueChange) {
  scope["ControlledHandler:" + nodeAccessor] = valueChange;
  if (valueChange) {
    scope["ControlledType:" + nodeAccessor] = 3;
    scope["ControlledValue:" + nodeAccessor] = value2;
  } else {
    scope["ControlledType:" + nodeAccessor] = 5;
  }
  pendingEffects.unshift(
    () => setSelectOptions(
      scope[nodeAccessor],
      value2,
      valueChange
    ),
    scope
  );
}
function controllable_select_value_effect(scope, nodeAccessor) {
  const el = scope[nodeAccessor];
  const onChange = () => {
    const valueChange = scope["ControlledHandler:" + nodeAccessor];
    if (valueChange) {
      const newValue = Array.isArray(
        scope["ControlledValue:" + nodeAccessor]
      ) ? Array.from(el.selectedOptions, toValueProp) : el.value;
      setSelectOptions(
        el,
        scope["ControlledValue:" + nodeAccessor],
        valueChange
      );
      valueChange(newValue);
      run();
    }
  };
  if (!el._) {
    new MutationObserver(() => {
      const value2 = scope["ControlledValue:" + nodeAccessor];
      if (Array.isArray(value2) ? value2.length !== el.selectedOptions.length || value2.some((value3, i) => value3 != el.selectedOptions[i].value) : el.value != value2) {
        onChange();
      }
    }).observe(el, {
      childList: true,
      subtree: true
    });
  }
  syncControllable(el, "input", hasSelectChanged, onChange);
}
function setSelectOptions(el, value2, valueChange) {
  if (Array.isArray(value2)) {
    for (const opt of el.options) {
      const selected = value2.includes(opt.value);
      if (valueChange) {
        opt.selected = selected;
      } else {
        opt.defaultSelected = selected;
      }
    }
  } else {
    const normalizedValue = normalizeStrProp(value2);
    if (valueChange) {
      el.value = normalizedValue;
    } else {
      for (const opt of el.options) {
        opt.defaultSelected = opt.value === normalizedValue;
      }
    }
  }
}
function controllable_detailsOrDialog_open(scope, nodeAccessor, open, openChange) {
  scope["ControlledHandler:" + nodeAccessor] = openChange;
  if (openChange) {
    scope["ControlledType:" + nodeAccessor] = 4;
  } else {
    scope["ControlledType:" + nodeAccessor] = 5;
  }
  scope[nodeAccessor].open = scope["ControlledValue:" + nodeAccessor] = normalizeBoolProp(open);
}
function controllable_detailsOrDialog_open_effect(scope, nodeAccessor) {
  const el = scope[nodeAccessor];
  const hasChanged = () => el.open !== scope["ControlledValue:" + nodeAccessor];
  syncControllable(
    el,
    el.tagName === "DIALOG" ? "close" : "toggle",
    hasChanged,
    () => {
      const openChange = scope["ControlledHandler:" + nodeAccessor];
      if (openChange && hasChanged()) {
        const newValue = el.open;
        el.open = !newValue;
        openChange(newValue);
        run();
      }
    }
  );
}
var inputType = "";
function setValueAndUpdateSelection(el, value2) {
  if (el.value !== value2) {
    const updatedPosition = resolveCursorPosition(
      inputType,
      el.getRootNode().activeElement === el && el.selectionStart,
      el.value,
      el.value = value2
    );
    if (~updatedPosition) {
      el.setSelectionRange(updatedPosition, updatedPosition);
    }
  }
}
function setCheckboxValue(scope, nodeAccessor, type, checked, checkedChange) {
  scope["ControlledHandler:" + nodeAccessor] = checkedChange;
  if (checkedChange) {
    scope["ControlledType:" + nodeAccessor] = type;
    scope[nodeAccessor].checked = checked;
  } else {
    scope["ControlledType:" + nodeAccessor] = 5;
    scope[nodeAccessor].defaultChecked = checked;
  }
}
var controllableDelegate = createDelegator();
function syncControllable(el, event, hasChanged, onChange) {
  if (!el._) {
    controllableDelegate(el, event, handleChange);
    if (el.form) {
      controllableDelegate(el.form, "reset", handleFormReset);
    }
    if (isResuming && hasChanged(el)) {
      queueMicrotask(onChange);
    }
  }
  el._ = onChange;
}
function handleChange(ev) {
  ev.target._?.(ev);
}
function handleFormReset(ev) {
  const handlers = [];
  for (const el of ev.target.elements) {
    if (el._ && hasFormElementChanged(el)) {
      handlers.push(el._);
    }
  }
  requestAnimationFrame(() => {
    if (!ev.defaultPrevented) {
      for (const change of handlers) {
        change();
      }
    }
  });
}
function hasValueChanged(el) {
  return el.value !== el.defaultValue;
}
function hasCheckboxChanged(el) {
  return el.checked !== el.defaultChecked;
}
function hasSelectChanged(el) {
  for (const opt of el.options) {
    if (opt.selected !== opt.defaultSelected) {
      return true;
    }
  }
}
function hasFormElementChanged(el) {
  return el.options ? hasSelectChanged(el) : hasValueChanged(el) || hasCheckboxChanged(el);
}
function normalizeStrProp(value2) {
  return normalizeAttrValue(value2) || "";
}
function normalizeBoolProp(value2) {
  return value2 != null && value2 !== false;
}
function updateList(arr, val, push) {
  const index = arr.indexOf(val);
  return (push ? !~index && [...arr, val] : ~index && arr.slice(0, index).concat(arr.slice(index + 1))) || arr;
}
function toValueProp(it) {
  return it.value;
}
var parsers = {};
function parseHTML(html2, ns) {
  const parser = parsers[ns] ||= document.createElementNS(ns, "template");
  parser.innerHTML = html2;
  return parser.content || parser;
}
function createScope($global, closestBranch) {
  const scope = {
    ___id: $global.___nextScopeId++,
    ___creating: 1,
    ___closestBranch: closestBranch,
    $global
  };
  pendingScopes.push(scope);
  return scope;
}
function skipScope(scope) {
  return scope.$global.___nextScopeId++;
}
function findBranchWithKey(scope, key) {
  let branch = scope.___closestBranch;
  while (branch && !branch[key]) {
    branch = branch.___parentBranch;
  }
  return branch;
}
function destroyBranch(branch) {
  branch.___parentBranch?.___branchScopes?.delete(branch);
  destroyNestedBranches(branch);
}
function destroyNestedBranches(branch) {
  branch.___destroyed = 1;
  branch.___branchScopes?.forEach(destroyNestedBranches);
  branch.___abortScopes?.forEach((scope) => {
    for (const id in scope.___abortControllers) {
      scope.___abortControllers[id]?.abort();
    }
  });
}
function removeAndDestroyBranch(branch) {
  destroyBranch(branch);
  removeChildNodes(branch.___startNode, branch.___endNode);
}
function insertBranchBefore(branch, parentNode, nextSibling) {
  insertChildNodes(
    parentNode,
    nextSibling,
    branch.___startNode,
    branch.___endNode
  );
}
function tempDetachBranch(branch) {
  const fragment = new DocumentFragment();
  fragment.namespaceURI = branch.___startNode.parentNode.namespaceURI;
  insertChildNodes(fragment, null, branch.___startNode, branch.___endNode);
}
var runTask;
var isScheduled;
var channel;
function schedule() {
  if (!isScheduled) {
    if (true) {
      if (console.createTask) {
        const task = console.createTask("queue");
        runTask = () => task.run(run);
      } else {
        runTask = run;
      }
    }
    isScheduled = 1;
    queueMicrotask(flushAndWaitFrame);
  }
}
function flushAndWaitFrame() {
  if (true) {
    runTask();
  } else {
    run();
  }
  requestAnimationFrame(triggerMacroTask);
}
function triggerMacroTask() {
  if (!channel) {
    channel = new MessageChannel();
    channel.port1.onmessage = () => {
      isScheduled = 0;
      if (true) {
        const run2 = runTask;
        runTask = void 0;
        run2();
      } else {
        run();
      }
    };
  }
  channel.port2.postMessage(0);
}
function state(valueAccessor, fn) {
  if (true) {
    var id = +valueAccessor.slice(
      valueAccessor.lastIndexOf("/") + 1
    );
    valueAccessor = valueAccessor.slice(
      0,
      valueAccessor.lastIndexOf("/")
    );
  }
  const valueChangeAccessor = "TagVariableChange:" + valueAccessor;
  const update = (scope, value2) => {
    if (scope[valueAccessor] !== value2) {
      scope[valueAccessor] = value2;
      fn(scope, value2);
    }
  };
  return (scope, value2, valueChange) => {
    if (rendering) {
      if ((scope[valueChangeAccessor] = valueChange) && scope[valueAccessor] !== value2 || !(valueAccessor in scope)) {
        scope[valueAccessor] = value2;
        fn(scope, value2);
      }
    } else if (scope[valueChangeAccessor]) {
      scope[valueChangeAccessor](value2);
    } else {
      schedule();
      queueRender(
        scope,
        update,
        true ? id : valueAccessor,
        value2
      );
    }
    return value2;
  };
}
function value(valueAccessor, fn = () => {
}) {
  return (scope, value2) => {
    if (!(valueAccessor in scope) || scope[valueAccessor] !== value2) {
      scope[valueAccessor] = value2;
      fn(scope, value2);
    }
  };
}
function intersection(id, fn, defaultPending = 1, scopeIdAccessor = /* @__KEY__ */ "___id") {
  return (scope) => {
    if (scope.___creating) {
      if (scope[id] === void 0) {
        scope[id] = defaultPending;
      } else if (!--scope[id]) {
        fn(scope);
      }
    } else {
      queueRender(scope, fn, id, 0, scope[scopeIdAccessor]);
    }
  };
}
function loopClosure(valueAccessor, ownerLoopNodeAccessor, fn) {
  const childSignal = closure(valueAccessor, fn);
  const loopScopeAccessor = "LoopScopeArray:" + ownerLoopNodeAccessor;
  const loopScopeMapAccessor = "LoopScopeMap:" + ownerLoopNodeAccessor;
  const ownerSignal = (ownerScope) => {
    const scopes = ownerScope[loopScopeAccessor] ||= ownerScope[loopScopeMapAccessor] ? [...ownerScope[loopScopeMapAccessor].values()] : [];
    const [firstScope] = scopes;
    if (firstScope) {
      queueRender(
        ownerScope,
        () => {
          for (const scope of scopes) {
            if (!scope.___creating && !scope.___destroyed) {
              childSignal(scope);
            }
          }
        },
        -1,
        0,
        firstScope.___id
      );
    }
  };
  ownerSignal._ = childSignal;
  return ownerSignal;
}
function conditionalClosure(valueAccessor, ownerConditionalNodeAccessor, branch, fn) {
  const childSignal = closure(valueAccessor, fn);
  const scopeAccessor = "ConditionalScope:" + ownerConditionalNodeAccessor;
  const branchAccessor = "ConditionalRenderer:" + ownerConditionalNodeAccessor;
  const ownerSignal = (scope) => {
    const ifScope = scope[scopeAccessor];
    if (ifScope && !ifScope.___creating && scope[branchAccessor] === branch) {
      queueRender(ifScope, childSignal, -1);
    }
  };
  ownerSignal._ = childSignal;
  return ownerSignal;
}
function subscribeToScopeSet(ownerScope, accessor, scope) {
  const subscribers = ownerScope[accessor] ||= /* @__PURE__ */ new Set();
  if (!subscribers.has(scope)) {
    subscribers.add(scope);
    getAbortSignal(scope, -1).addEventListener(
      "abort",
      () => ownerScope[accessor].delete(scope)
    );
  }
}
function dynamicClosure(...closureSignals) {
  const [{ ___scopeInstancesAccessor, ___signalIndexAccessor }] = closureSignals;
  for (let i = closureSignals.length; i--; ) {
    closureSignals[i].___index = i;
  }
  return (scope) => {
    if (scope[___scopeInstancesAccessor]) {
      for (const childScope of scope[___scopeInstancesAccessor]) {
        if (!childScope.___creating) {
          queueRender(
            childScope,
            closureSignals[childScope[___signalIndexAccessor]],
            -1
          );
        }
      }
    }
  };
}
function dynamicClosureRead(valueAccessor, fn, getOwnerScope) {
  const childSignal = closure(valueAccessor, fn, getOwnerScope);
  const closureSignal = (scope) => {
    scope[closureSignal.___signalIndexAccessor] = closureSignal.___index;
    childSignal(scope);
    subscribeToScopeSet(
      getOwnerScope ? getOwnerScope(scope) : scope[
        "_"
        /* Owner */
      ],
      closureSignal.___scopeInstancesAccessor,
      scope
    );
  };
  closureSignal.___scopeInstancesAccessor = "ClosureScopes:" + valueAccessor;
  closureSignal.___signalIndexAccessor = "ClosureSignalIndex:" + valueAccessor;
  return closureSignal;
}
function closure(valueAccessor, fn, getOwnerScope) {
  return (scope) => {
    fn(
      scope,
      (getOwnerScope ? getOwnerScope(scope) : scope[
        "_"
        /* Owner */
      ])[valueAccessor]
    );
  };
}
function setTagVar(scope, childAccessor, tagVarSignal2) {
  scope[childAccessor][
    "#TagVariable"
    /* TagVariable */
  ] = (value2) => tagVarSignal2(scope, value2);
}
var tagVarSignal = (scope, value2) => scope[
  "#TagVariable"
  /* TagVariable */
]?.(value2);
function setTagVarChange(scope, changeHandler) {
  scope[
    "#TagVariableChange"
    /* TagVariableChange */
  ] = changeHandler;
}
var tagVarSignalChange = (scope, value2) => scope[
  "#TagVariableChange"
  /* TagVariableChange */
]?.(value2);
var tagIdsByGlobal = /* @__PURE__ */ new WeakMap();
function nextTagId({ $global }) {
  const id = tagIdsByGlobal.get($global) || 0;
  tagIdsByGlobal.set($global, id + 1);
  return "c" + $global.runtimeId + $global.renderId + id.toString(36);
}
function effect(id, fn) {
  register(id, fn);
  return (scope) => {
    queueEffect(scope, fn);
  };
}
function* traverseAllHoisted(scope, path, curIndex = path.length - 1) {
  if (scope) {
    if (Symbol.iterator in scope) {
      for (const s of scope instanceof Map ? scope.values() : scope) {
        yield* traverseAllHoisted(s, path, curIndex);
      }
    } else if (curIndex) {
      yield* traverseAllHoisted(scope[path[curIndex]], path, curIndex - 1);
    } else {
      yield scope[path[0]];
    }
  }
}
function hoist(...path) {
  return (scope) => {
    const getOne = (...args) => iterator().next().value(...args);
    const iterator = getOne[Symbol.iterator] = () => traverseAllHoisted(scope, path);
    return getOne;
  };
}
var walker = document.createTreeWalker(document);
function walk(startNode, walkCodes, branch) {
  walker.currentNode = startNode;
  walkInternal(0, walkCodes, branch);
}
function walkInternal(currentWalkIndex, walkCodes, scope) {
  let value2;
  let storedMultiplier = 0;
  let currentMultiplier = 0;
  let currentScopeIndex = 0;
  for (; currentWalkIndex < walkCodes.length; ) {
    value2 = walkCodes.charCodeAt(currentWalkIndex++);
    currentMultiplier = storedMultiplier;
    storedMultiplier = 0;
    if (value2 === 32) {
      const node = walker.currentNode;
      scope[true ? getDebugKey(currentScopeIndex, walker.currentNode) : currentScopeIndex] = node;
      scope["Getter:" + (true ? getDebugKey(currentScopeIndex++, walker.currentNode) : currentScopeIndex++)] = () => node;
    } else if (value2 === 37 || value2 === 49) {
      walker.currentNode.replaceWith(
        walker.currentNode = scope[true ? getDebugKey(currentScopeIndex++, "#text") : currentScopeIndex++] = new Text()
      );
      if (value2 === 49) {
        scope[true ? getDebugKey(currentScopeIndex++, "#scopeOffset") : currentScopeIndex++] = skipScope(scope);
      }
    } else if (value2 === 38) {
      return currentWalkIndex;
    } else if (value2 === 47 || value2 === 48) {
      currentWalkIndex = walkInternal(
        currentWalkIndex,
        walkCodes,
        scope[true ? getDebugKey(currentScopeIndex++, "#childScope") : currentScopeIndex++] = createScope(scope.$global, scope.___closestBranch)
      );
      if (value2 === 48) {
        scope[true ? getDebugKey(currentScopeIndex++, "#scopeOffset") : currentScopeIndex++] = skipScope(scope);
      }
    } else if (value2 < 91 + 1) {
      value2 = 20 * currentMultiplier + value2 - 67;
      while (value2--) {
        walker.nextNode();
      }
    } else if (value2 < 106 + 1) {
      value2 = 10 * currentMultiplier + value2 - 97;
      while (value2--) {
        walker.nextSibling();
      }
    } else if (value2 < 116 + 1) {
      value2 = 10 * currentMultiplier + value2 - 107;
      while (value2--) {
        walker.parentNode();
      }
      walker.nextSibling();
    } else {
      if (value2 < 117 || value2 > 126) {
        throw new Error(`Unknown walk code: ${value2}`);
      }
      storedMultiplier = currentMultiplier * 10 + value2 - 117;
    }
  }
}
function getDebugKey(index, node) {
  if (typeof node === "string") {
    return `${node}/${index}`;
  } else if (node.nodeType === 3) {
    return `#text/${index}`;
  } else if (node.nodeType === 8) {
    return `#comment/${index}`;
  } else if (node.nodeType === 1) {
    return `#${node.tagName.toLowerCase()}/${index}`;
  }
  return index;
}
function createBranch($global, renderer, parentScope, parentNode) {
  const branch = createScope($global);
  const parentBranch = parentScope?.___closestBranch;
  branch[
    "_"
    /* Owner */
  ] = renderer.___owner || parentScope;
  branch.___closestBranch = branch;
  if (parentBranch) {
    branch.___parentBranch = parentBranch;
    (parentBranch.___branchScopes ||= /* @__PURE__ */ new Set()).add(branch);
  }
  if (true) {
    branch.___renderer = renderer;
  }
  renderer.___clone?.(
    branch,
    parentNode.namespaceURI
  );
  return branch;
}
function createAndSetupBranch($global, renderer, parentScope, parentNode) {
  return setupBranch(
    renderer,
    createBranch($global, renderer, parentScope, parentNode)
  );
}
function setupBranch(renderer, branch) {
  if (renderer.___setup) {
    queueRender(branch, renderer.___setup, -1);
  }
  return branch;
}
function createContent(id, template, walks, setup, params, dynamicScopesAccessor) {
  walks = walks ? walks.replace(/[^\0-1]+$/, "") : "";
  setup = setup ? setup._ || setup : void 0;
  params ||= void 0;
  const clone = template ? (branch, ns) => {
    ((cloneCache[ns] ||= {})[template] ||= createCloneableHTML(
      template,
      ns
    ))(branch, walks);
  } : (branch) => {
    walk(
      branch.___startNode = branch.___endNode = new Text(),
      walks,
      branch
    );
  };
  return (owner) => {
    return {
      ___id: id,
      ___clone: clone,
      ___owner: owner,
      ___setup: setup,
      ___params: params,
      ___accessor: dynamicScopesAccessor
    };
  };
}
function registerContent(id, template, walks, setup, params, dynamicScopesAccessor) {
  return register(
    id,
    createContent(id, template, walks, setup, params, dynamicScopesAccessor)
  );
}
function localClosures(renderer, closureFns) {
  const closureSignals = {};
  for (const key in closureFns) {
    closureSignals[key] = value(key, closureFns[key]);
  }
  return (owner, closureValues) => {
    const instance = renderer(owner);
    instance.___localClosures = closureSignals;
    instance.___localClosureValues = closureValues;
    return instance;
  };
}
function createRenderer(template, walks, setup, params) {
  return createContent("", template, walks, setup, params)();
}
var cloneCache = {};
function createCloneableHTML(html2, ns) {
  const { firstChild, lastChild } = parseHTML(html2, ns);
  const parent = document.createElementNS(ns, "t");
  insertChildNodes(parent, null, firstChild, lastChild);
  return firstChild === lastChild && firstChild.nodeType < 8 ? (branch, walks) => {
    walk(
      branch.___startNode = branch.___endNode = firstChild.cloneNode(true),
      walks,
      branch
    );
  } : (branch, walks) => {
    const clone = parent.cloneNode(true);
    walk(clone.firstChild, walks, branch);
    branch.___startNode = clone.firstChild;
    branch.___endNode = clone.lastChild;
  };
}
function attr(element, name, value2) {
  setAttribute(element, name, normalizeAttrValue(value2));
}
function setAttribute(element, name, value2) {
  if (element.getAttribute(name) != value2) {
    if (value2 === void 0) {
      element.removeAttribute(name);
    } else {
      element.setAttribute(name, value2);
    }
  }
}
function classAttr(element, value2) {
  setAttribute(element, "class", classValue(value2) || void 0);
}
function classItems(element, items) {
  for (const key in items) {
    classItem(element, key, items[key]);
  }
}
function classItem(element, name, value2) {
  element.classList.toggle(name, !!value2);
}
function styleAttr(element, value2) {
  setAttribute(element, "style", styleValue(value2) || void 0);
}
function styleItems(element, items) {
  for (const key in items) {
    styleItem(element, key, items[key]);
  }
}
function styleItem(element, name, value2) {
  element.style.setProperty(name, value2 || value2 === 0 ? value2 + "" : "");
}
function data(node, value2) {
  const normalizedValue = normalizeString(value2);
  if (node.data !== normalizedValue) {
    node.data = normalizedValue;
  }
}
function textContent(node, value2) {
  const normalizedValue = normalizeString(value2);
  if (node.textContent !== normalizedValue) {
    node.textContent = normalizedValue;
  }
}
function attrs(scope, nodeAccessor, nextAttrs) {
  const el = scope[nodeAccessor];
  for (let i = el.attributes.length; i--; ) {
    const { name } = el.attributes.item(i);
    if (!(nextAttrs && (name in nextAttrs || hasAttrAlias(el, name, nextAttrs)))) {
      el.removeAttribute(name);
    }
  }
  attrsInternal(scope, nodeAccessor, nextAttrs);
}
function attrsAndContent(scope, nodeAccessor, nextAttrs) {
  attrs(scope, nodeAccessor, nextAttrs);
  insertContent(scope, nodeAccessor, nextAttrs?.content);
}
function hasAttrAlias(element, attr2, nextAttrs) {
  return attr2 === "checked" && element.tagName === "INPUT" && "checkedValue" in nextAttrs;
}
function partialAttrs(scope, nodeAccessor, nextAttrs, skip) {
  const el = scope[nodeAccessor];
  const partial = {};
  for (let i = el.attributes.length; i--; ) {
    const { name } = el.attributes.item(i);
    if (!skip[name] && !(nextAttrs && name in nextAttrs)) {
      el.removeAttribute(name);
    }
  }
  for (const key in nextAttrs) {
    if (!skip[key]) partial[key] = nextAttrs[key];
  }
  attrsInternal(scope, nodeAccessor, partial);
}
function partialAttrsAndContent(scope, nodeAccessor, nextAttrs, skip) {
  partialAttrs(scope, nodeAccessor, nextAttrs, skip);
  insertContent(scope, nodeAccessor, nextAttrs?.content);
}
function attrsInternal(scope, nodeAccessor, nextAttrs) {
  const el = scope[nodeAccessor];
  let events;
  let skip;
  switch (el.tagName) {
    case "INPUT":
      if ("checked" in nextAttrs || "checkedChange" in nextAttrs) {
        controllable_input_checked(
          scope,
          nodeAccessor,
          nextAttrs.checked,
          nextAttrs.checkedChange
        );
      } else if ("checkedValue" in nextAttrs || "checkedValueChange" in nextAttrs) {
        controllable_input_checkedValue(
          scope,
          nodeAccessor,
          nextAttrs.checkedValue,
          nextAttrs.checkedValueChange,
          nextAttrs.value
        );
      } else if ("value" in nextAttrs || "valueChange" in nextAttrs) {
        controllable_input_value(
          scope,
          nodeAccessor,
          nextAttrs.value,
          nextAttrs.valueChange
        );
      } else {
        break;
      }
      skip = /^(?:value|checked(?:Value)?)(?:Change)?$/;
      break;
    case "SELECT":
      if ("value" in nextAttrs || "valueChange" in nextAttrs) {
        controllable_select_value(
          scope,
          nodeAccessor,
          nextAttrs.value,
          nextAttrs.valueChange
        );
        skip = /^value(?:Change)?$/;
      }
      break;
    case "TEXTAREA":
      if ("value" in nextAttrs || "valueChange" in nextAttrs) {
        controllable_input_value(
          scope,
          nodeAccessor,
          nextAttrs.value,
          nextAttrs.valueChange
        );
        skip = /^value(?:Change)?$/;
      }
      break;
    case "DETAILS":
    case "DIALOG":
      if ("open" in nextAttrs || "openChange" in nextAttrs) {
        controllable_detailsOrDialog_open(
          scope,
          nodeAccessor,
          nextAttrs.open,
          nextAttrs.openChange
        );
        skip = /^open(?:Change)?$/;
      }
      break;
  }
  for (const name in nextAttrs) {
    const value2 = nextAttrs[name];
    switch (name) {
      case "class":
        classAttr(el, value2);
        break;
      case "style":
        styleAttr(el, value2);
        break;
      case "content": {
        break;
      }
      default: {
        if (isEventHandler(name)) {
          (events ||= scope["EventAttributes:" + nodeAccessor] = {})[getEventHandlerName(name)] = value2;
        } else if (!skip?.test(name)) {
          attr(el, name, value2);
        }
      }
    }
  }
}
function insertContent(scope, nodeAccessor, value2) {
  const content = normalizeClientRender(value2);
  const rendererAccessor = "ConditionalRenderer:" + nodeAccessor;
  if (scope[rendererAccessor] !== (scope[rendererAccessor] = content?.___id)) {
    setConditionalRenderer(scope, nodeAccessor, content, createAndSetupBranch);
    if (content?.___accessor) {
      subscribeToScopeSet(
        content.___owner,
        content.___accessor,
        scope["ConditionalScope:" + nodeAccessor]
      );
    }
  }
}
function attrsEvents(scope, nodeAccessor) {
  const el = scope[nodeAccessor];
  const events = scope["EventAttributes:" + nodeAccessor];
  switch (scope["ControlledType:" + nodeAccessor]) {
    case 0:
      controllable_input_checked_effect(scope, nodeAccessor);
      break;
    case 1:
      controllable_input_checkedValue_effect(scope, nodeAccessor);
      break;
    case 2:
      controllable_input_value_effect(scope, nodeAccessor);
      break;
    case 3:
      controllable_select_value_effect(scope, nodeAccessor);
      break;
    case 4:
      controllable_detailsOrDialog_open_effect(scope, nodeAccessor);
      break;
  }
  for (const name in events) {
    on(el, name, events[name]);
  }
}
function html(scope, value2, accessor) {
  const firstChild = scope[accessor];
  const parentNode = firstChild.parentNode;
  const lastChild = scope["DynamicPlaceholderLastChild:" + accessor] || firstChild;
  const newContent = parseHTML(
    value2 || value2 === 0 ? value2 + "" : "",
    parentNode.namespaceURI
  );
  insertChildNodes(
    parentNode,
    firstChild,
    scope[accessor] = newContent.firstChild || newContent.appendChild(new Text()),
    scope["DynamicPlaceholderLastChild:" + accessor] = newContent.lastChild
  );
  removeChildNodes(firstChild, lastChild);
}
function normalizeClientRender(value2) {
  const renderer = normalizeDynamicRenderer(value2);
  if (renderer) {
    if (renderer.___id) {
      return renderer;
    } else if (true) {
      throw new Error(
        `Invalid \`content\` attribute. Received ${typeof value2}`
      );
    }
  }
}
function props(scope, nodeIndex, index) {
  const nextProps = scope[index];
  const prevProps = scope[index + "-"];
  const node = scope[nodeIndex];
  if (prevProps) {
    for (const name in prevProps) {
      if (!(name in nextProps)) {
        node[name] = void 0;
      }
    }
  }
  for (const name in nextProps) {
    node[name] = nextProps[name];
  }
  scope[index + "-"] = nextProps;
}
function normalizeAttrValue(value2) {
  if (value2 || value2 === 0) {
    return value2 === true ? "" : value2 + "";
  }
}
function normalizeString(value2) {
  return value2 || value2 === 0 ? value2 + "" : "‍";
}
function lifecycle(scope, index, thisObj) {
  const instance = scope[index];
  if (instance) {
    Object.assign(instance, thisObj);
    instance.onUpdate?.();
  } else {
    scope[index] = thisObj;
    thisObj.onMount?.();
    getAbortSignal(
      scope,
      "LifecycleAbortController:" + index
    ).onabort = () => thisObj.onDestroy?.();
  }
}
function removeChildNodes(startNode, endNode) {
  const stop = endNode.nextSibling;
  let current = startNode;
  while (current !== stop) {
    const next = current.nextSibling;
    current.remove();
    current = next;
  }
}
function insertChildNodes(parentNode, referenceNode, startNode, endNode) {
  parentNode.insertBefore(toInsertNode(startNode, endNode), referenceNode);
}
function toInsertNode(startNode, endNode) {
  if (startNode === endNode) return startNode;
  const parent = new DocumentFragment();
  const stop = endNode.nextSibling;
  let current = startNode;
  while (current !== stop) {
    const next = current.nextSibling;
    parent.appendChild(current);
    current = next;
  }
  return parent;
}
var WRONG_POS = 2147483647;
function reconcile(parent, oldBranches, newBranches, afterReference) {
  let oldStart = 0;
  let newStart = 0;
  let oldEnd = oldBranches.length - 1;
  let newEnd = newBranches.length - 1;
  let oldStartBranch = oldBranches[oldStart];
  let newStartBranch = newBranches[newStart];
  let oldEndBranch = oldBranches[oldEnd];
  let newEndBranch = newBranches[newEnd];
  let i;
  let j;
  let k;
  let nextSibling;
  let oldBranch;
  let newBranch;
  outer: {
    while (oldStartBranch === newStartBranch) {
      ++oldStart;
      ++newStart;
      if (oldStart > oldEnd || newStart > newEnd) {
        break outer;
      }
      oldStartBranch = oldBranches[oldStart];
      newStartBranch = newBranches[newStart];
    }
    while (oldEndBranch === newEndBranch) {
      --oldEnd;
      --newEnd;
      if (oldStart > oldEnd || newStart > newEnd) {
        break outer;
      }
      oldEndBranch = oldBranches[oldEnd];
      newEndBranch = newBranches[newEnd];
    }
  }
  if (oldStart > oldEnd) {
    if (newStart <= newEnd) {
      k = newEnd + 1;
      nextSibling = k < newBranches.length ? newBranches[k].___startNode : afterReference;
      do {
        insertBranchBefore(newBranches[newStart++], parent, nextSibling);
      } while (newStart <= newEnd);
    }
  } else if (newStart > newEnd) {
    do {
      removeAndDestroyBranch(oldBranches[oldStart++]);
    } while (oldStart <= oldEnd);
  } else {
    const oldLength = oldEnd - oldStart + 1;
    const newLength = newEnd - newStart + 1;
    const aNullable = oldBranches;
    const sources = new Array(newLength);
    for (i = 0; i < newLength; ++i) {
      sources[i] = -1;
    }
    let pos = 0;
    let synced = 0;
    const keyIndex = /* @__PURE__ */ new Map();
    for (j = newStart; j <= newEnd; ++j) {
      keyIndex.set(newBranches[j], j);
    }
    for (i = oldStart; i <= oldEnd && synced < newLength; ++i) {
      oldBranch = oldBranches[i];
      j = keyIndex.get(oldBranch);
      if (j !== void 0) {
        pos = pos > j ? WRONG_POS : j;
        ++synced;
        newBranch = newBranches[j];
        sources[j - newStart] = i;
        aNullable[i] = null;
      }
    }
    if (oldLength === oldBranches.length && synced === 0) {
      for (; newStart < newLength; ++newStart) {
        insertBranchBefore(newBranches[newStart], parent, afterReference);
      }
      for (; oldStart < oldLength; ++oldStart) {
        removeAndDestroyBranch(oldBranches[oldStart]);
      }
    } else {
      i = oldLength - synced;
      while (i > 0) {
        oldBranch = aNullable[oldStart++];
        if (oldBranch !== null) {
          removeAndDestroyBranch(oldBranch);
          i--;
        }
      }
      if (pos === WRONG_POS) {
        const seq = longestIncreasingSubsequence(sources);
        j = seq.length - 1;
        k = newBranches.length;
        for (i = newLength - 1; i >= 0; --i) {
          if (sources[i] === -1) {
            pos = i + newStart;
            newBranch = newBranches[pos++];
            nextSibling = pos < k ? newBranches[pos].___startNode : afterReference;
            insertBranchBefore(newBranch, parent, nextSibling);
          } else {
            if (j < 0 || i !== seq[j]) {
              pos = i + newStart;
              newBranch = newBranches[pos++];
              nextSibling = pos < k ? newBranches[pos].___startNode : afterReference;
              insertBranchBefore(newBranch, parent, nextSibling);
            } else {
              --j;
            }
          }
        }
      } else if (synced !== newLength) {
        k = newBranches.length;
        for (i = newLength - 1; i >= 0; --i) {
          if (sources[i] === -1) {
            pos = i + newStart;
            newBranch = newBranches[pos++];
            nextSibling = pos < k ? newBranches[pos].___startNode : afterReference;
            insertBranchBefore(newBranch, parent, nextSibling);
          }
        }
      }
    }
  }
}
function longestIncreasingSubsequence(a) {
  const p = a.slice();
  const result = [0];
  let u;
  let v;
  for (let i = 0, il = a.length; i < il; ++i) {
    if (a[i] === -1) {
      continue;
    }
    const j = result[result.length - 1];
    if (a[j] < a[i]) {
      p[i] = j;
      result.push(i);
      continue;
    }
    u = 0;
    v = result.length - 1;
    while (u < v) {
      const c = (u + v) / 2 | 0;
      if (a[result[c]] < a[i]) {
        u = c + 1;
      } else {
        v = c;
      }
    }
    if (a[i] < a[result[u]]) {
      if (u > 0) {
        p[i] = result[u - 1];
      }
      result[u] = i;
    }
  }
  u = result.length;
  v = result[u - 1];
  while (u-- > 0) {
    result[u] = v;
    v = p[v];
  }
  return result;
}
function awaitTag(nodeAccessor, renderer) {
  const promiseAccessor = "Promise:" + nodeAccessor;
  const branchAccessor = "ConditionalScope:" + nodeAccessor;
  return (scope, promise) => {
    const referenceNode = scope[nodeAccessor];
    const tryWithPlaceholder = findBranchWithKey(
      scope,
      "#PlaceholderContent"
      /* PlaceholderContent */
    );
    let awaitBranch = scope[branchAccessor];
    if (tryWithPlaceholder) {
      placeholderShown.add(pendingEffects);
      if (!scope[promiseAccessor] && (tryWithPlaceholder.___pendingAsyncCount = (tryWithPlaceholder.___pendingAsyncCount || 0) + 1) === 1) {
        requestAnimationFrame(
          () => tryWithPlaceholder.___pendingAsyncCount && runEffects(
            prepareEffects(
              () => queueRender(
                tryWithPlaceholder,
                () => {
                  insertBranchBefore(
                    tryWithPlaceholder[
                      "#PlaceholderBranch"
                      /* PlaceholderBranch */
                    ] = createAndSetupBranch(
                      scope.$global,
                      tryWithPlaceholder[
                        "#PlaceholderContent"
                        /* PlaceholderContent */
                      ],
                      tryWithPlaceholder[
                        "_"
                        /* Owner */
                      ],
                      tryWithPlaceholder.___startNode.parentNode
                    ),
                    tryWithPlaceholder.___startNode.parentNode,
                    tryWithPlaceholder.___startNode
                  );
                  tempDetachBranch(tryWithPlaceholder);
                },
                -1
              )
            )
          )
        );
      }
    } else if (awaitBranch && !scope[promiseAccessor]) {
      awaitBranch.___startNode.parentNode.insertBefore(
        referenceNode,
        awaitBranch.___startNode
      );
      tempDetachBranch(awaitBranch);
    }
    const thisPromise = scope[promiseAccessor] = promise.then(
      (data2) => {
        if (thisPromise === scope[promiseAccessor]) {
          scope[promiseAccessor] = 0;
          schedule();
          queueRender(
            scope,
            () => {
              if (awaitBranch) {
                if (!tryWithPlaceholder) {
                  referenceNode.replaceWith(
                    awaitBranch.___startNode.parentNode
                  );
                }
              } else {
                insertBranchBefore(
                  awaitBranch = scope[branchAccessor] = createAndSetupBranch(
                    scope.$global,
                    renderer,
                    scope,
                    referenceNode.parentNode
                  ),
                  referenceNode.parentNode,
                  referenceNode
                );
                referenceNode.remove();
              }
              renderer.___params?.(awaitBranch, [data2]);
              if (tryWithPlaceholder) {
                placeholderShown.add(pendingEffects);
                if (!--tryWithPlaceholder.___pendingAsyncCount) {
                  const placeholderBranch = tryWithPlaceholder[
                    "#PlaceholderBranch"
                    /* PlaceholderBranch */
                  ];
                  tryWithPlaceholder[
                    "#PlaceholderBranch"
                    /* PlaceholderBranch */
                  ] = 0;
                  if (placeholderBranch) {
                    placeholderBranch.___startNode.parentNode.insertBefore(
                      tryWithPlaceholder.___startNode.parentNode,
                      placeholderBranch.___startNode
                    );
                    removeAndDestroyBranch(placeholderBranch);
                  }
                  if (tryWithPlaceholder.___effects) {
                    runEffects(tryWithPlaceholder.___effects, true);
                  }
                }
              }
            },
            -1
          );
        }
      },
      (error) => {
        if (thisPromise === scope[promiseAccessor]) {
          if (tryWithPlaceholder) tryWithPlaceholder.___pendingAsyncCount = 0;
          scope[promiseAccessor] = 0;
          schedule();
          queueRender(scope, renderCatch, -1, error);
        }
      }
    );
  };
}
function createTry(nodeAccessor, tryContent) {
  const branchAccessor = "ConditionalScope:" + nodeAccessor;
  return (scope, input) => {
    if (!scope[branchAccessor]) {
      setConditionalRenderer(
        scope,
        nodeAccessor,
        tryContent,
        createAndSetupBranch
      );
    }
    const branch = scope[branchAccessor];
    if (branch) {
      branch[
        "#BranchAccessor"
        /* BranchAccessor */
      ] = nodeAccessor;
      branch[
        "#CatchContent"
        /* CatchContent */
      ] = normalizeDynamicRenderer(input.catch);
      branch[
        "#PlaceholderContent"
        /* PlaceholderContent */
      ] = normalizeDynamicRenderer(
        input.placeholder
      );
    }
  };
}
function renderCatch(scope, error) {
  const tryWithCatch = findBranchWithKey(
    scope,
    "#CatchContent"
    /* CatchContent */
  );
  if (!tryWithCatch) {
    throw error;
  } else {
    const owner = tryWithCatch[
      "_"
      /* Owner */
    ];
    const placeholderBranch = tryWithCatch[
      "#PlaceholderBranch"
      /* PlaceholderBranch */
    ];
    if (placeholderBranch) {
      tryWithCatch.___pendingAsyncCount = 0;
      owner["ConditionalScope:" + tryWithCatch[
        "#BranchAccessor"
        /* BranchAccessor */
      ]] = placeholderBranch;
      destroyBranch(tryWithCatch);
    }
    caughtError.add(pendingEffects);
    setConditionalRenderer(
      owner,
      tryWithCatch[
        "#BranchAccessor"
        /* BranchAccessor */
      ],
      tryWithCatch[
        "#CatchContent"
        /* CatchContent */
      ],
      createAndSetupBranch
    );
    tryWithCatch[
      "#CatchContent"
      /* CatchContent */
    ].___params?.(
      owner["ConditionalScope:" + tryWithCatch[
        "#BranchAccessor"
        /* BranchAccessor */
      ]],
      [error]
    );
  }
}
function conditional(nodeAccessor, ...branches) {
  const branchAccessor = "ConditionalRenderer:" + nodeAccessor;
  enableBranches();
  return (scope, newBranch) => {
    if (newBranch !== scope[branchAccessor]) {
      setConditionalRenderer(
        scope,
        nodeAccessor,
        branches[scope[branchAccessor] = newBranch],
        createAndSetupBranch
      );
    }
  };
}
function patchDynamicTag(fn) {
  dynamicTag = fn(dynamicTag);
}
var dynamicTag = function dynamicTag2(nodeAccessor, getContent, getTagVar, inputIsArgs) {
  const childScopeAccessor = "ConditionalScope:" + nodeAccessor;
  const rendererAccessor = "ConditionalRenderer:" + nodeAccessor;
  enableBranches();
  return (scope, newRenderer, getInput) => {
    const normalizedRenderer = normalizeDynamicRenderer(newRenderer);
    if (scope[rendererAccessor] !== (scope[rendererAccessor] = normalizedRenderer?.___id || normalizedRenderer) || getContent && !(normalizedRenderer || scope[childScopeAccessor])) {
      setConditionalRenderer(
        scope,
        nodeAccessor,
        normalizedRenderer || (getContent ? getContent(scope) : void 0),
        createBranchWithTagNameOrRenderer
      );
      if (getTagVar) {
        setTagVar(scope, childScopeAccessor, getTagVar());
      }
      if (typeof normalizedRenderer === "string") {
        if (getContent) {
          const content = getContent(scope);
          setConditionalRenderer(
            scope[childScopeAccessor],
            true ? `#${normalizedRenderer}/0` : 0,
            content,
            createAndSetupBranch
          );
          if (content.___accessor) {
            subscribeToScopeSet(
              content.___owner,
              content.___accessor,
              scope[childScopeAccessor]["ConditionalScope:" + (true ? `#${normalizedRenderer}/0` : 0)]
            );
          }
        }
      } else if (normalizedRenderer?.___accessor) {
        subscribeToScopeSet(
          normalizedRenderer.___owner,
          normalizedRenderer.___accessor,
          scope[childScopeAccessor]
        );
      }
    }
    if (normalizedRenderer) {
      const childScope = scope[childScopeAccessor];
      const args = getInput?.();
      if (typeof normalizedRenderer === "string") {
        attrs(
          childScope,
          true ? `#${normalizedRenderer}/0` : 0,
          (inputIsArgs ? args[0] : args) || {}
        );
      } else {
        for (const accessor in normalizedRenderer.___localClosures) {
          normalizedRenderer.___localClosures[accessor](
            childScope,
            normalizedRenderer.___localClosureValues[accessor]
          );
        }
        if (normalizedRenderer.___params) {
          if (inputIsArgs) {
            normalizedRenderer.___params(
              childScope,
              normalizedRenderer._ ? args[0] : args
            );
          } else {
            const inputWithContent = getContent ? { ...args, content: getContent(scope) } : args || {};
            normalizedRenderer.___params(
              childScope,
              normalizedRenderer._ ? inputWithContent : [inputWithContent]
            );
          }
        }
      }
    }
  };
};
function setConditionalRenderer(scope, nodeAccessor, newRenderer, createBranch2) {
  const referenceNode = scope[nodeAccessor];
  const prevBranch = scope["ConditionalScope:" + nodeAccessor];
  const parentNode = referenceNode.nodeType > 1 ? (prevBranch?.___startNode || referenceNode).parentNode : referenceNode;
  const newBranch = scope["ConditionalScope:" + nodeAccessor] = newRenderer && createBranch2(scope.$global, newRenderer, scope, parentNode);
  if (referenceNode === parentNode) {
    if (prevBranch) {
      destroyBranch(prevBranch);
      referenceNode.textContent = "";
    }
    if (newBranch) {
      insertBranchBefore(newBranch, parentNode, null);
    }
  } else if (prevBranch) {
    if (newBranch) {
      insertBranchBefore(newBranch, parentNode, prevBranch.___startNode);
    } else {
      parentNode.insertBefore(referenceNode, prevBranch.___startNode);
    }
    removeAndDestroyBranch(prevBranch);
  } else if (newBranch) {
    insertBranchBefore(newBranch, parentNode, referenceNode);
    referenceNode.remove();
  }
}
function loopOf(nodeAccessor, renderer) {
  return loop(
    nodeAccessor,
    renderer,
    ([all, by = bySecondArg], cb) => {
      if (typeof by === "string") {
        forOf(
          all,
          (item, i) => cb(item[by], [item, i])
        );
      } else {
        forOf(all, (item, i) => cb(by(item, i), [item, i]));
      }
    }
  );
}
function loopIn(nodeAccessor, renderer) {
  return loop(
    nodeAccessor,
    renderer,
    ([obj, by = byFirstArg], cb) => forIn(obj, (key, value2) => cb(by(key, value2), [key, value2]))
  );
}
function loopTo(nodeAccessor, renderer) {
  return loop(
    nodeAccessor,
    renderer,
    ([to, from, step, by = byFirstArg], cb) => forTo(to, from, step, (v) => cb(by(v), [v]))
  );
}
function loop(nodeAccessor, renderer, forEach) {
  const params = renderer.___params;
  enableBranches();
  return (scope, value2) => {
    const referenceNode = scope[nodeAccessor];
    const oldMap = scope["LoopScopeMap:" + nodeAccessor];
    const oldArray = oldMap ? scope["LoopScopeArray:" + nodeAccessor] || [
      ...oldMap.values()
    ] : [];
    const parentNode = referenceNode.nodeType > 1 ? referenceNode.parentNode || oldArray[0].___startNode.parentNode : referenceNode;
    const newMap = scope["LoopScopeMap:" + nodeAccessor] = /* @__PURE__ */ new Map();
    const newArray = scope["LoopScopeArray:" + nodeAccessor] = [];
    forEach(value2, (key, args) => {
      const branch = oldMap?.get(key) || createAndSetupBranch(scope.$global, renderer, scope, parentNode);
      params?.(branch, args);
      newMap.set(key, branch);
      newArray.push(branch);
    });
    let afterReference = null;
    if (referenceNode !== parentNode) {
      if (oldArray.length) {
        afterReference = oldArray[oldArray.length - 1].___endNode.nextSibling;
        if (!newArray.length) {
          parentNode.insertBefore(referenceNode, afterReference);
        }
      } else if (newArray.length) {
        afterReference = referenceNode.nextSibling;
        referenceNode.remove();
      }
    }
    reconcile(parentNode, oldArray, newArray, afterReference);
  };
}
function createBranchWithTagNameOrRenderer($global, tagNameOrRenderer, parentScope, parentNode) {
  const branch = createBranch(
    $global,
    tagNameOrRenderer,
    parentScope,
    parentNode
  );
  if (typeof tagNameOrRenderer === "string") {
    branch[true ? `#${tagNameOrRenderer}/0` : 0] = branch.___startNode = branch.___endNode = document.createElementNS(
      tagNameOrRenderer === "svg" ? "http://www.w3.org/2000/svg" : tagNameOrRenderer === "math" ? "http://www.w3.org/1998/Math/MathML" : parentNode.namespaceURI,
      tagNameOrRenderer
    );
  } else {
    setupBranch(tagNameOrRenderer, branch);
  }
  return branch;
}
function bySecondArg(_item, index) {
  return index;
}
function byFirstArg(name) {
  return name;
}
var pendingRenders = [];
var pendingRendersLookup = /* @__PURE__ */ new Map();
var caughtError = /* @__PURE__ */ new WeakSet();
var placeholderShown = /* @__PURE__ */ new WeakSet();
var pendingEffects = [];
var pendingScopes = [];
var rendering;
var scopeKeyOffset = 1e3;
function queueRender(scope, signal, signalKey, value2, scopeKey = scope.___id) {
  const key = scopeKey * scopeKeyOffset + signalKey;
  const existingRender = signalKey >= 0 && pendingRendersLookup.get(key);
  if (existingRender) {
    existingRender.___value = value2;
  } else {
    const render = {
      ___key: key,
      ___scope: scope,
      ___signal: signal,
      ___value: value2
    };
    let i = pendingRenders.push(render) - 1;
    while (i) {
      const parentIndex = i - 1 >> 1;
      const parent = pendingRenders[parentIndex];
      if (key - parent.___key >= 0) break;
      pendingRenders[i] = parent;
      i = parentIndex;
    }
    signalKey >= 0 && pendingRendersLookup.set(key, render);
    pendingRenders[i] = render;
  }
}
function queueEffect(scope, fn) {
  pendingEffects.push(fn, scope);
}
function run() {
  const effects = pendingEffects;
  try {
    rendering = 1;
    runRenders();
  } finally {
    pendingRenders = [];
    pendingRendersLookup = /* @__PURE__ */ new Map();
    pendingEffects = [];
    rendering = 0;
  }
  runEffects(effects);
}
function prepareEffects(fn) {
  const prevRenders = pendingRenders;
  const prevRendersLookup = pendingRendersLookup;
  const prevEffects = pendingEffects;
  const preparedEffects = pendingEffects = [];
  pendingRenders = [];
  pendingRendersLookup = /* @__PURE__ */ new Map();
  try {
    rendering = 1;
    fn();
    runRenders();
  } finally {
    rendering = 0;
    pendingRenders = prevRenders;
    pendingRendersLookup = prevRendersLookup;
    pendingEffects = prevEffects;
  }
  return preparedEffects;
}
var runEffects = (effects) => {
  for (let i = 0, scope; i < effects.length; ) {
    effects[i++](
      scope = effects[i++],
      scope
    );
  }
};
function runRenders() {
  while (pendingRenders.length) {
    const render = pendingRenders[0];
    const item = pendingRenders.pop();
    if (render !== item) {
      let i = 0;
      const mid = pendingRenders.length >> 1;
      const key = (pendingRenders[0] = item).___key;
      while (i < mid) {
        let bestChild = (i << 1) + 1;
        const right = bestChild + 1;
        if (right < pendingRenders.length && pendingRenders[right].___key - pendingRenders[bestChild].___key < 0) {
          bestChild = right;
        }
        if (pendingRenders[bestChild].___key - key >= 0) {
          break;
        } else {
          pendingRenders[i] = pendingRenders[bestChild];
          i = bestChild;
        }
      }
      pendingRenders[i] = item;
    }
    if (!render.___scope.___closestBranch?.___destroyed) {
      runRender(render);
    }
  }
  for (const scope of pendingScopes) {
    scope.___creating = 0;
  }
  pendingScopes = [];
}
var runRender = (render) => render.___signal(render.___scope, render.___value);
var enableCatch = () => {
  enableCatch = () => {
  };
  enableBranches();
  const handlePendingTry = (fn, scope, branch) => {
    while (branch) {
      if (branch.___pendingAsyncCount) {
        return (branch.___effects ||= []).push(fn, scope);
      }
      branch = branch.___parentBranch;
    }
  };
  runEffects = /* @__PURE__ */ ((runEffects2) => (effects, checkPending = placeholderShown.has(effects)) => {
    if (checkPending || caughtError.has(effects)) {
      let i = 0;
      let fn;
      let scope;
      let branch;
      for (; i < effects.length; ) {
        fn = effects[i++];
        scope = effects[i++];
        branch = scope.___closestBranch;
        if (!branch?.___destroyed && !(checkPending && handlePendingTry(fn, scope, branch))) {
          fn(scope, scope);
        }
      }
    } else {
      runEffects2(effects);
    }
  })(runEffects);
  runRender = /* @__PURE__ */ ((runRender2) => (render) => {
    try {
      runRender2(render);
    } catch (error) {
      renderCatch(render.___scope, error);
    }
  })(runRender);
};
function resetAbortSignal(scope, id) {
  const ctrl = scope.___abortControllers?.[id];
  if (ctrl) {
    queueEffect(ctrl, abort);
    scope.___abortControllers[id] = void 0;
  }
}
function getAbortSignal(scope, id) {
  if (scope.___closestBranch) {
    (scope.___closestBranch.___abortScopes ||= /* @__PURE__ */ new Set()).add(scope);
  }
  return ((scope.___abortControllers ||= {})[id] ||= new AbortController()).signal;
}
function abort(ctrl) {
  ctrl.abort();
}
var prefix = true ? "$compat_" : "$C_";
var RENDERER_REGISTER_ID = prefix + (true ? "renderer" : "r");
var SET_SCOPE_REGISTER_ID = prefix + (true ? "setScope" : "s");
var RENDER_BODY_ID = prefix + (true ? "renderBody" : "b");
var classIdToBranch = /* @__PURE__ */ new Map();
var compat = {
  patchDynamicTag,
  queueEffect,
  init(warp10Noop) {
    register(SET_SCOPE_REGISTER_ID, (branch) => {
      classIdToBranch.set(branch.m5c, branch);
    });
    register(RENDER_BODY_ID, warp10Noop);
  },
  registerRenderer(fn) {
    register(RENDERER_REGISTER_ID, fn);
  },
  isRenderer(renderer) {
    return renderer.___clone;
  },
  getStartNode(branch) {
    return branch.___startNode;
  },
  setScopeNodes(branch, startNode, endNode) {
    branch.___startNode = startNode;
    branch.___endNode = endNode;
  },
  runComponentEffects() {
    runEffects(this.effects);
  },
  runComponentDestroy() {
    if (this.scope) {
      destroyBranch(this.scope);
    }
  },
  resolveRegistered(value2, {
    runtimeId,
    componentIdPrefix
  }) {
    if (Array.isArray(value2) && typeof value2[0] === "string") {
      return getRegisteredWithScope(
        value2[0],
        value2.length === 2 && self[runtimeId]?.[componentIdPrefix === "s" ? "_" : componentIdPrefix]?.s[value2[1]]
      );
    }
    return value2;
  },
  createRenderer(params, clone) {
    const renderer = createRenderer(0, 0, 0, params);
    renderer.___clone = (branch) => {
      const cloned = clone();
      branch.___startNode = cloned.startNode;
      branch.___endNode = cloned.endNode;
    };
    return renderer;
  },
  render(out, component, renderer, args) {
    let branch = component.scope;
    if (!branch) {
      branch = classIdToBranch.get(component.id);
      if (branch) {
        component.scope = branch;
        classIdToBranch.delete(component.id);
      }
    }
    let existing;
    if (typeof args[0] === "object" && "renderBody" in args[0]) {
      const input = args[0];
      const normalizedInput = args[0] = {};
      for (const key in input) {
        normalizedInput[key === "renderBody" ? "content" : key] = input[key];
      }
    }
    component.effects = prepareEffects(() => {
      if (!branch) {
        out.global.___nextScopeId ||= 0;
        branch = component.scope = createAndSetupBranch(
          out.global,
          renderer,
          renderer.___owner,
          document.body
        );
      } else {
        existing = 1;
      }
      renderer.___params?.(branch, renderer._ ? args[0] : args);
    });
    if (!existing) {
      return toInsertNode(branch.___startNode, branch.___endNode);
    }
  }
};
var createTemplate = (id, template, walks, setup, inputSignal) => {
  const renderer = createContent(
    id,
    template,
    walks,
    setup,
    inputSignal
  )();
  renderer.mount = mount;
  renderer._ = renderer;
  if (true) {
    renderer.render = () => {
      throw new Error(
        `render() is not implemented for the DOM compilation of a Marko template`
      );
    };
  }
  return register(id, renderer);
};
function mount(input = {}, reference, position) {
  let branch;
  let parentNode = reference;
  let nextSibling = null;
  let { $global } = input;
  if ($global) {
    ({ $global, ...input } = input);
    $global = {
      ___nextScopeId: 0,
      runtimeId: DEFAULT_RUNTIME_ID,
      renderId: DEFAULT_RENDER_ID,
      ...$global
    };
  } else {
    $global = {
      ___nextScopeId: 0,
      runtimeId: DEFAULT_RUNTIME_ID,
      renderId: DEFAULT_RENDER_ID
    };
  }
  switch (position) {
    case "beforebegin":
      parentNode = reference.parentNode;
      nextSibling = reference;
      break;
    case "afterbegin":
      nextSibling = reference.firstChild;
      break;
    case "afterend":
      parentNode = reference.parentNode;
      nextSibling = reference.nextSibling;
      break;
  }
  let curValue;
  const args = this.___params;
  const effects = prepareEffects(() => {
    branch = createBranch(
      $global,
      this,
      void 0,
      parentNode
    );
    branch[
      "#TagVariable"
      /* TagVariable */
    ] = (newValue) => {
      curValue = newValue;
    };
    this.___setup?.(branch);
    args?.(branch, input);
  });
  insertChildNodes(
    parentNode,
    nextSibling,
    branch.___startNode,
    branch.___endNode
  );
  runEffects(effects);
  return {
    get value() {
      return curValue;
    },
    set value(newValue) {
      tagVarSignalChange(branch, newValue);
    },
    update(newInput) {
      if (args) {
        runEffects(
          prepareEffects(() => {
            args(branch, newInput);
          })
        );
      }
    },
    destroy() {
      removeAndDestroyBranch(branch);
    }
  };
}
export {
  attr,
  attrTag,
  attrTags,
  attrs,
  attrsAndContent,
  attrsEvents,
  awaitTag,
  classAttr,
  classItem,
  classItems,
  compat,
  conditional,
  conditionalClosure,
  controllable_detailsOrDialog_open,
  controllable_detailsOrDialog_open_effect,
  controllable_input_checked,
  controllable_input_checkedValue,
  controllable_input_checkedValue_effect,
  controllable_input_checked_effect,
  controllable_input_value,
  controllable_input_value_effect,
  controllable_select_value,
  controllable_select_value_effect,
  controllable_input_value as controllable_textarea_value,
  controllable_input_value_effect as controllable_textarea_value_effect,
  createContent,
  createRenderer,
  createTemplate,
  createTry,
  data,
  dynamicClosure,
  dynamicClosureRead,
  dynamicTag,
  effect,
  enableCatch,
  forIn,
  forOf,
  forTo,
  getAbortSignal,
  hoist,
  html,
  init,
  insertContent,
  intersection,
  lifecycle,
  localClosures,
  loopClosure,
  loopIn,
  loopOf,
  loopTo,
  nextTagId,
  nodeRef,
  on,
  partialAttrs,
  partialAttrsAndContent,
  props,
  register,
  registerBoundSignal,
  registerContent,
  resetAbortSignal,
  run,
  setTagVar,
  setTagVarChange,
  state,
  styleAttr,
  styleItem,
  styleItems,
  tagVarSignal,
  tagVarSignalChange,
  textContent,
  value
};
//# sourceMappingURL=marko_debug_dom.js.map
