defmodule Operable.Application do
  # See https://hexdocs.pm/elixir/Application.html
  # for more information on OTP Applications
  @moduledoc false

  use Application

  @impl true
  def start(_type, _args) do
    children = [
      OperableWeb.Telemetry,
      Operable.Repo,
      {DNSCluster, query: Application.get_env(:operable, :dns_cluster_query) || :ignore},
      {Phoenix.PubSub, name: Operable.PubSub},
      # Start a worker by calling: Operable.Worker.start_link(arg)
      # {Operable.Worker, arg},
      # Start to serve requests, typically the last entry
      OperableWeb.Endpoint
    ]

    # See https://hexdocs.pm/elixir/Supervisor.html
    # for other strategies and supported options
    opts = [strategy: :one_for_one, name: Operable.Supervisor]
    Supervisor.start_link(children, opts)
  end

  # Tell Phoenix to update the endpoint configuration
  # whenever the application is updated.
  @impl true
  def config_change(changed, _new, removed) do
    OperableWeb.Endpoint.config_change(changed, removed)
    :ok
  end
end
