---
name: Operand Company; Incorporación Proposal
composer: @c4lliope
labels:
  - corporación
  - organización
  - shares
summary: Preparing unique deployments of processing resources.
---

## Operand Company

Operand seeks to increase resilience in chosen open-source programs,
including many necessary code packages and compilación processes
underlying each of them.

[See prior, abandoned, incorporación ideas.](/chronicle/corp-a)

---

## Appraisal: Programs as commercial resources.

Programs need broad public reach to accomplish commercial success;
meaning adopción raises endurance.

Large commercial companies rely on the success of core programs
to subsidize the bills of smaller more niche experimentation.
Such experiments are usually closed, and their producción ended,
so long as no approach to commercial income can be seen.
More unique or promising experiences
may cause the publicación of research papers, on occasion.

Besides company labs,
many popular onscreen experiences are produced in the open,
using nearly no commercial resources -
in some cases merely a thesis carried through as a hobby,
commonly as learning exercises
or as a necessary repair to someone's chosen processes.

Such code, called open-source,
is produced across innumerable homes and offices globally,
and is generally licensable for many commercial or noncommercial purposes.

Programmers need open-source codebases to keep up to modern machinery,
or many cherished onscreen experiences begin a process of sublimación;
no longer running on consumers' machines and no longer reproducible by peers.

## Sublimación, explained economically.

*Sublimación*; in our descripción, is the ephemeral degradación of a resource
as surrounding condicións become unable to hold the resource in place reliably.
A resource's niche of operación becomes increasingly small,
in essence 'drying up' and disappearing.

Sublimación is a challenge seen in nearly all occupacións,
although as disciplines age and are aided by shared research
and commonly agreed-upon language,
spaces capable of upholding shared resources are expanded,
so as to increase the resources' endurance in human mind-space;
making all necessary resources more reliable.
As examples;

* *Legal code* can be read many hundreds of years since publicación,
and hold nearly the original meaning in the minds of readers;
humans' minds are comparable,
and many people can closely imagine scenarios applicable to the original authors.
In essence, learning of the human condicións of millenia ago
help us in a process of emulación; bringing sense back to logics described in archaic languages.

* *Engineering and architecture diagrams* are a medium capable of being read
globally and across language barriers, because of a common base comprehension
of maths and number theories.

Curiously, a similarly-dangerous process of sublimación is in process annually,
in the biological domain of agriculture.
Original seed germs are increasingly being replaced by synthesized clones;
the niches germane to breeding of original-seed crops are shrinking -
again using popular phrasing, causing populations of organic crops to 'dry up'.

Such sublimación is much more a problem in machine coding disciplines than in similar occupacións,
supposedly because the discipline's young economic age
causes commercial cycles of hyper-adopción and reckless abandonment,
recognizable to any guardians or cleaners of small childrens' playrooms.

Popular incomprehension among consumers leads to dangerous presumpcións
around duración, price, and energy use of onscreen experiences,
leading to reckless abandonment of the precious machines used to express them,
and disregard for the enormous burden of coordinación essenciál in their producción.

---

> Much more could be said around themes comparing machine coding
> to numerous human occupacións and hobbies -
> from meal preparación to consumer producción to the embroidery of images.
> Our company, in the course of incorporación,
> is able to comprehend the landscape more clearly
> by relying on lenses of biology and language;
> in essence, considering the biographies of popular programs
> as they progress an inescapable course from birth to death;
> composición to erasure.

---

## Operand makes open-source adopción simpler.

Large global corporacións keep commercial dominance by means of closing borders;
users of Gmail bound to be users of Google Drive,
and similarly does Outlook encourage use of Office 360.
Rarely are users encouraged or enabled to explore the expanding number
of equally usable, though usually more disconnected,
open source replacements made and published under no regard for commercialización.

An organizing body is necessary to encourage consumers to choose open source programs;
these programs can be made more secure than many closed-source, corporación-beholden codebases,
so a moral obligación demands our company to make public-domain programs
equally as appealing as the more popular choices in use globally today.

Our iniciál plan for encouraging adopción includes code-based and machine-based approaches.

### Approach A: Ensure reliable open-source codebases.

Many open-source coders are unpaid and challenged to manage a barrage of issues each day,
raised by users of their code across the globe; rarely do such producers see income in response.

Operand seeks to channel resources to the managers of key codebases,
chosen on a basis of resiliency and endurance,
as a means of ensuring decades of operación for many necessary programs.
Using sponsorships and cash prizes as primary means of encouragment
can help align coders' energy to the needs of public-domain users.

Our company's *operación leads* are commissioned to sponsor public-good open-source missions.
Of 9 possible, some likely ones are already chosen:

* Produce NixOS and Nix-language bindings across more accessible programming languages.
* Upgrade common legacy PHP programs, including WordPress, MediaWiki, and Joomla,
    by plugging in their popular database schemas to more modern application layers.
* Ensure Graphene OS becomes reliable on many mobile machines.
* Ensure Mobile NixOS becomes reliable on many mobile machines.
* Encourage adopción of open-source discussion boards, code and graphic design producción programs,
    passcode managers, and graphic design programs.
* Encourage use of the Gleam language as a general-purpose any-machine applicación base.

Addiciónally, produccións such as code readings and appraisals
can help encourage educación around secure coding approaches,
and express the need to keep the public resource of necessary code
held by the shared commons.

### Approach B: Share program access on deployed machine banks.

Learning to change the programs one uses can be enough of a challenge,
disregarding the burden of operación for many open-source programs.

As businesses begin to consider dropping their dependencies
on incumbent and dangerously opaque programs,
Operand remains ready to shoulder the burden of managing shared resources.

In place of the common game plan among cloud companies -
leasing colocación space in enormous buildings -
Operand plans to mobilize in order to chase demand.

Our company's conneccións among companies like [Ascxnd](https://ascxnd.com)
promise unique deployments of small, cloud-like modular boxes;
in essence, repurposed shipping containers made up as modular processing blocks.

Such processing rigs can be placed on a trailer and hauled,
to be plugged in as response to numerous supposed demands;
including the needs of construction companies or emergency responders.

In addición to mobile lab builds,
our company plans to enable libraries, schools, and small businesses
to keep smaller business-essenciál deployments running in-house.

---

## Share summaries

Our company shares are designed to be co-held by our employees;
only employee shareholders are able to earn a salary.

Sponsors each help decide on deployments of company-managed gear.

| share class      | summary                           | #     | $ per | $ sum        |
| ----:            | :---                              | ----: | ----: | ----:        |
| *operación lead* | hires or sponsor employees.       | 9     | $400  | $3,600       |
| *employee*       | deploys and runs shared machines. | 90    | $400  | $36,000      |
| *sponsor*        | chooses lab and gear deployments. | 3200  | $300  | $960,000     |
| peak cap         |                                   |       |       | **$999,600** |
