---
name: Compose
composer: c4lliope
summary: |
  [Ink and Switch](https://inkandswitch.com) is breaking common ground using some amazing approaches in collaboracion; here is a simple submission.
labels:
  - correspondence
  - ink&switch
---

Hi, Peter and Alex;

I'm glad you messaged, especially to learn how the House of Representatives is doing business these days. I could speak for hours and hours on this theme, and I'm glad for a chance to organize some of these ideas prior to sharing more broadly on my domain.

- - -

A good place to begin is by glancing through the House XML schemas, shared on [xml.house.gov].

for years, those schemas have described all ofthe legislation shared on [congress.gov]. You can see one of these schemas, called [bill_dtd], copied into Automerge & Prosemirror code (although the prosemirror code precedes automerge, and the binding is surely lacking).

[xml.house.gov]: https://xml.house.gov
[congress.gov]: https://congress.gov/
[bill_dtd]: https://operand.online/gram/page/src/schema.js

Aside from these now-legacy schemas, some composition is already happening in a new model, [US Legislative Markup][USLM]. USLM is far from the daily use you'd hope to see after years in incubation, mainly because of the horrid inaccessibility of the composition engine in use since 1985; [XMetaL].

[USLM]: https://github.com/usgpo/uslm
[XMetaL]: https://xmetal.com

XMetaL has been in use far longer than any normal enterprise program, because of the organization's inability to make a sensible upgrade. WYSIWYG is top-of-mind for lawyers, and combined alongside legislation's need for a rigorous schema, and burdensome procurement policies, my first glance at XMetaL involved combing through 3000+ macros, in a combination of JavaScript, Perl, and VBScript, to bind the editor to the needs of the House. Meanwhile, the Senate procedures around drafting had diverged, producing another unique collection of thousands of macros.

After months of pain and dread caused by this predicament, [I recorded my screen][screen] one day so I could remember the horrors; otherwise, this program has earned its place in the so-called online dark ages.

<video controls>
  <source src="https://share.operand.online/2023-01-04.xmetal.webm" type="video/webm"/>
</video>

[screen]: https://share.operand.online/2023-01-04.xmetal.mkv

So, I'm sure such a program made sense in the beginning, when WordPerfect had been in common use and the internet was for email. The one serious concern to be raised about using this in the 2020's is, how do you educate hundreds of new staffers to use such a hodgepodge program, each couple years?

Uh... and so the horror becomes an embarrassment. Because no one does learn to use this; there is no congressional member office that composes legislation directly. Those staffers, and I'm sure some adventurous members, all use Microsoft Word, and then email a support office called [Legislative Counsel][counsel]. The LegCounsel has a couple - shockingly few - career lawyers who smush all these amazing-or-dangerous policy ideas into an amazing-or-dangerous legal schema. So one small and sad office of lawyers types all the laws congress passes or fails to pass, year after year. This old XML program has them chained to their keyboards and inboxes.

Once their draft, made in XMetaL, properly imagines the ideas from the members' email attachments, they need to clear the language with the member. So, one of the many macros is able to export a Microsoft Word document. Uh. Yeah. The draft goes back to Microsoft Word. And the drafted language `.docx` (I was responsible for adding the `x`) is marked for "Track Changes", and once again attached to an email. Clearly, the aim of this email is the generation of another word document, designed to capture any corrections the member has in mind. I'd like to say this is all handled in less than three round trips; because this is the only case in my career I've felt a need to describe NFS shares to lawyers. Only please do bear in mind the couple bills surpassing 3000 pages, proposed and passed during each year's appropriations season. If you're close to crying or screaming then you're beginning to realize the cause of Congressional unpopularity.

[counsel]: https://legcounsel.house.gov/

Ah, yeah. You're also seeing why I am so eager to make new connections; especially among coders again, and especially among those who are re-imagining applications. I made a big push as an employee for in-house program design, and I deployed numerous open-source programs on premise, all of which were met with demands from my boss to return to our vendor-contracted waterfall design process on an app to smash more email attachments, now through some proprietary Microsoft Azure pipelines. I recall some Microsoft employees being daily regulars on our planning calls, mainly to echo and encourage the one House employee who has experience deploying to Kubernetes. After 15 months, I gladly said goodbye; then took another two years to clean up the damage to my sobriety, which has included moving onto a sailboat in the Chesapeake Bay; another splendid use case for local programs on low-energy machines (see [100r.co]).

[100r.co]: https://100r.co

I am gradually impressing upon my former colleagues that far from being bliss, their ignorance is causing their pain to progress to an incurable degree; I am also making a case that there are new approaches being made, and I had a chance to play key pieces of your LocalFirstFM interview during Tuesday's meeting. Really though, I can only describe their 250-year-old operation as a circus, dressed for church and singing to the percussion of a hammer on a podium.

- - -

Luckily, I had chances to bond connections to nearly all of the responsible support offices in the House, and momentum for change nearly always begins in the 430-member house before reaching the deliberate, languid echelon of 100 Senators who seem to imagine some quill-smudges on parchment can hold up for a quarter-millenium.

These support offices are full of people who can explain in narcolepsy-inducing depth (and indeed, my narcolepsy began here in DC) the specific causes and reasons behind each procedure - clearly mixing up reasonable and sensible. In all cases, they came to the Capitol complex in admiration of the elected paragons of democracy who demand that anyone in a support office "pay grade" shall remain nameless in any designs. Once I recognized that this dynamic causes all decisions of consequence to be shelled out; commissioned to private companies, I happily embraced the arguments that led to termination; and then quickly re-incorporated my solo LLC company as a DC corporation, able to raise nearly a million USD in capital. In essence, all this means is that I published an essay in a blog; I do remain proud of [the essay].

[the essay]: https://operand.online/chronicle/corp

I also spent many hours in local engineering groups, such as [HacDC] - where [HyperDemocracy](https://huggingface.co/hyperdemocracy) came to be. The LLM craze has all my neighbors in a serious hype, while I am simply preoccupied by how to access my coding dependencies offshore. As HacDC's secretary and one of the few who has seen the energy of an early career in San Francisco (also during Rdio's days), I did a bunch of research on where local programs are going - during one hackathon I packaged up Elixir/Erlang's BEAM VM, alongside SQLite, into a native Android app. I began reading as much Ink & Switch as I could, and I'm glad to see you all picking up your pace, as you release production apps and packages. I seriously considered ending my coding career long ago, because all roads began looking like dead ends; your philosophies share a rare coherence that leads to much more humane experiences.

[HacDC]: https://hacdc.org
[HyperDemocracy]: https://huggingface.co/hyperdemocracy

As I gather courage again to aim at the issues surrounding Congress, I am also digging in on a problem raised by HacDC - the need to migrate their domain from the common combination of WordPress & MediaWiki; I'd like to enable both programs to dump pages to a `.git` codebase, to be equally rendered by a local offline reader (hat-tip to Aaron Swartz and the enduring legacy of RSS readers), or an online domain process necessary for search-engine propagation (and I hope we can discuss how to apportion granular search indices across machines, perhaps under sail near the Puget Sound someday).

- - -

This message has clearly become the embodiment of a deep and rich mess of problems, unique to the boundary line of aeons-old legal code, and decades-old machine code. I am seriously glad to speak to you as you consider how to mature the idea of application programming to a new generation; the nascent approaches are nonsense in the nation-building landscape. Although the 12-factor essay made for good reading in 2015, the other side of the coin has 10 commandments etched in.
I clearly need nothing more than a space to share and discuss this summary of issues; it all seems much to serious for Discord and much too drab for many of the social circles in DC, where currency and security issues choke all considerations of consumer experience.

I am eager for any impressions you can share, before discussing resources. These ideas are all bound for the blog, and I am sure there are places I can sharpen or dull the language as needed.

Because there is such a deep scope in play, I'd like to coordinate among my local engineering groups before mirroring the discussions and code on GitHub or more popular domains. Peer coordination seems to be a special focus of your company's mission, so I am eager for recommendations on arranging dialogue and managing the build's progress. After years of managing the gradual decay of homelabs, my only lead is to spin up [soft-serve] as soon as possible.

[soft-serve]: https://github.com/charmbracelet/soft-serve

More than anything, I am immensely pleased to add to the dialogue around these approaches - I imagine that birds of a feather flock together, simply because they're all sick of where they've been so far, can smell the seasons changing, and realize it's going to be far too long a haul to manage alone.

Building up;
Calliope 
