---
name: Business Recipe
summary: Many companies use a 'road map'. Ours needs the energy to rise from (em)bed.
composer: c4lliope
labels:
  - business
  - plan
  - recipe
public: false
---

I'll begin by saying I am enormously obliged to [Open Gov Hub] in DC,
where I had a chance this week to begin leasing a desk.
Like all my belongings, I am already placing this under hard use.
I rolled up modular hardware boxes, rigged up a graphics design display,
plugged in an industrial 5g modem, and opened up a DSLR camera all in the first 5 days.

There is [an Open House] coming up on April 10;
if you are nearby I hope to see you, and please message me
so I can apply membership pricing ($0) to your admission.

Solid, and I am indescribably glad for the solid base and relationships among my peers in the space.
This day's page regards collaboración, labor aligned across many missions,
a consequence of principled dialogue and inclusion.

[Open Gov Hub]: https://opengovhub.org
[an Open House]: https://www.eventbrite.com/e/open-gov-hub-spring-open-house-tickets-1273587206619

- - -

As [you can see][commons],
a local group of peers is beginning to discuss alignment around 23andMe's sale.

Serious consideración is being applied to the consequences of a sale.
Normally, healthcare-conscious records are required to be managed using norms espoused by [HIPAA].
Per minimum, this requires any records to be sliced into pieces:
any informacón used to recognize who someone is,
and any información deemed to be guarded in consideración of health, social, and relaciónship concerns.

> I am paraphrasing here based on experience;
I had a couple commissions regarding HIPAA-managed records,
so I can lean on my aging memories.

Someone's gene sequence, as appraised by 23&Me, is... possibly a healthcare record?
Here's the rub(bish).

Yes, medical practicióners do care to learn someone's genome markers in many cases.
Yes, this is a science pursued by biological researchers mainly for medical purposes.
And yes, many consumers ordered 23&Me sequencing in a curious chase for some medical explanación.

And... no, 23&Me could hardly care less.

I mean, flippant pun aside, that 23&Me is playing a similar role to a chemical lab,
ordered to process residue from crime scenes.
They are able to say, "Yes, cocaine!" "No meth here!"
"This pee is has so much alcohol, it could be confused for a tequila sunrise!"

...and no one in the lab really cares to learn the condicións or scenario
leading to their holding a jar of pee close to their nose, moments before their lunch break.

Biology can be an odd science. My brain imagines odd scenes.
I'm sure there is no chance this precise play has occurred.

[commons]: /chronicle/biology-research.proposal
[HIPAA]: https://www.hhs.gov/hipaa/for-professionals/privacy/laws-regulations/index.html

- - -

So, 23&Me has for many years published their records -
I mean - their consumer's records -
I mean, their consumer's genomic sequences -
in [a large resource collección][research] open to academic researchers.
In the beginning of this year, the company's crises and panic
had them release a broader call for corporate research partnerships, called [Discover23].

[research]: https://research.23andme.com/dataset-access/
[Discover23]: https://investors.23andme.com/news-releases/news-release-details/23andme-launches-discover23-help-accelerate-large-scale-genetics

- - -

The precise records included in these colleccións is unclear,
and can seemingly be proscribed on a case-by-case basis,
according to each researcher's agreed-upon [Statement of Work][sow].

Our peers are in the process of deciding upon condicións to include in ours,
and hope to hear your concerns during this dialogue.

The main condicións do require:

- 23andMe data cannot be distributed, shared, or sold to third parties.
- Researchers must commit to publishing their research results in an open-access scientific journals (or open-access articles) and according to 23andMe’s publication best practices. Currently, those best practices only allow for the publication of summary statistics for up to 10,000 SNPs; this applies to meta-analyses that include 23andMe data.
- Researchers may not file for intellectual property rights covering the results of research using 23andMe data.
- Requests for 5 or more GWAS datasets may require additional information to be submitted for review by the 23andMe team.

[sow]: https://docs.google.com/forms/d/e/1FAIpQLSchNM4mPcB2b20g-9nP9UmL660hsb5CjPPIl2CCc_TVhCiMcw/viewform?fbzx=-3481938682094926426

- - -

The requirements also include a dependency on academic credenciál:

> Please note we require the **applicant to be at the associate professor level**. If the applicant is not an associate professor, we will not accept your application.

This is a small hinderance to address;
many of the peer researchers among us don the role of "citizen scientist",
a necessary response to the US nacionilización of educacional academia.

Here is a summary of the local philosophy:

[PubChem] and [PubMed] are some of the most densely meaningful resources for learning and exploración -
produced by humans, for humans, as a public good.
These resources, broadly speaking, are enormously underused.

For colleccións that expose PDFs, plaintext, and original LaTeX source,
as bulk downloads by FTP, as a searchable index, and as an online,
endlessly expanding hub for daily publicacións,
shockingly few people access any of the records for normal, common use cases.

Although there are no legal or mechanical barriers in place,
the social barriers of a naciónal and commercialized academic complex
means that unassiciated consumers learn none of the skills to reach for the resource.

A quick aside; this is a common sociological problem.
Unless someone learns to examine a problem, they see no need to.
More so, they are unlikely to realize that examinación is possible, or perhaps -
that the problem really is present.

The exchanging of disagreeable policy posicións during the preceding 4 years
has raised issues around the horrifying commercial predicament of (ivory) towering tuition prices
demanding the commission of abysmal student loans,
begging forgiveness for an issue caused, generación by generación,
by those who promised to lead and guide us in our learning process.
Some are learning to call the deal crap.

Some are learning, you can learn more by sequencing a pile of crap,
and then doing a search on public records,
and cross-referencing enormous bodies of prior research on crap,
than you can do by enrolling in a naciónally accreditted program
that bundles cohorts of pupils up for a package of loans
from the nearby credit union in cahoots.

[PubChem]: https://pubchem.ncbi.nlm.nih.gov/
[PubMed]: https://pubmed.ncbi.nlm.nih.gov/

So, our group is (perhaps?) seeking a principal investigator who holds a shiny,
crap-free credenciál of 'associate professor'.
By all measures, the less assiciación, the happier you'd make us.

- - -

In response, our peers can promise a ready-and-eager group of early-and-mid-career researchers,
happy to learn by unique approaches that may, in odd balance, seem inaccessible or impossible
to many of our coulda-been professors.

All of us are raised in the endlessly expanding spaces inherent to online communicación.

As a primer:

Two years ago, a regional group named [DMV Petri Dish][petri] pioneered research,
and published in a journal regarding drug efficacy for opposing neurofibramatosis.

- [NF1 Biology and Foundations](https://www.youtube.com/watch?v=ClPPDk2U7mg)
- [Historical Work on delta S](https://www.youtube.com/watch?v=DoCUE89MpYk)
- [delta S' and Future Work](https://www.youtube.com/watch?v=6aQCKOEZRU8)

[petri]: https://www.dmvpetridish.com/

The same year, Gabriel from the group led another local club called [HacDC],
in an experiment called [Hyperdemocracy].
This group produced a curriculum for around 15 engineers in a local library branch,
for a day's curriculum in processing [US congressional legislación][congress]
using modern language models and machine-learning approaches.

As someone who already had many of the source records copied and ready for use,
I'd been happy to learn that **many, many people** were eager to crack open the collección.

All of the group's code is public, once again, [here][Hyperdemocracy].

[HacDC]: https://hacdc.org
[Hyperdemocracy]: https://huggingface.co/hyperdemocracy
[congress]: https://www.congress.gov

- - -

Many members of these groups share colliding hobbies,
and see each other in the numerous clubs more or less aligned to our soul's calling.
None of us really bothers to assume the lead of an organized, college-mediated research program,
because all of us recognize the need to spur our educación in more broad-minded direccións.

Much more engaging dialogue happens each day in online spaces,
among meshes of peers who come across one another by key phrases and forum theses,
than any of us remember from our schooling days.

Gone is question-and-answer, gone is multiple-choice.
Essays rule the day, and no one really needs a grade,
assigned from on high-(school) so long as the dialogue remains aligned.

So please, help us build using the resources you can share.
Message! Please reach Ulisses, Matt, and Sam, at [the DMV Petri Dish](https://www.dmvpetridish.com/contact),
or Andrew, at [Healthcare for Change](https://healthcareforchange.org/contact/),
or Gabe, on [HacDC's many channels](https://www.hacdc.org/contact/),
or me, `c4lliope.99`, on [Signal] and `mail@operand.online`.

Each of us proceeds on our own pace, and cherishes the common ground among us.
And each of us is going to help you become a piece of our common dialogue,
because building in public is simpler, and easier, and more pleasing,
than hiding in fear.

[Aloha 'Āina].

[Signal]: https://signal.org
[Aloha 'Āina]: https://www.nps.gov/articles/000/values-aloha-aina.htm

- - -

> Organizing operacións are going to be legally conducted under the DC Nonprofit Corporación, Open Democracy (OD).
> Our amicus brief here is a framing piece, pending resumpción of OD's online presence.
