---
name: Code for America Summit / Scholarship Applicación
composer: c4lliope
summary: |
  Code for America has [an annual summit] -
  a conference to discuss how the public can use modern practices
  to build inclusion and humanity into our public processes.

  By email, I asked for the honor of joining them this month.

  [an annual summit]: https://summit.codeforamerica.org/
labels:
  - conference
  - background
  - apply
public: false
---

An [open inquiry].

[open inquiry]: https://operand.online/chronicle/cfa-summit.app

Coders for America,

In 2016 I'd been a fellow on CfA's Seattle squad,
building the app that would soon be re-branded as RideAlong.
I had different names then.

I left San Francisco, bounced and collided around the midwest and Philadelphia,
and headed back to San Francisco at the beginning of 2019 -
only to re-spark some old emotions and be scalded by the back-blaze; and by homelessness.

I began another, less managed collision course around the nation during the pandemic years,
and seized upon a chance to join the House of Reps' Clerk as a coder for an in-House app.
In this role I began designing programs to bring modern online collaboration
to Congressional offices.

Although I managed to find buy-in from other offices,
my direct managers had been adamant about contracting our program design
to private contracted agencies, and therefore prohibited the experiments I depend on.

Today this challenge is gradually cracking under increasing and focused pressure
of a small group of modernizers in Congress. Perhaps much too gradual.
Today the issue seems more pressing than I could have possibly imagined.
I remain on the good side of my occasionally high-pressure relationships
in the Congressional Modernization Staff Association,
and among the members of the House Digital Service who are succeeding to build.

- - -

I said goodbye, packed up, and began to dedicate my energies
as the secretary of HacDC, a local independent hacker-space in Columbia Heights.
According to rumor, this group is now seeing the building pulled from under them
in an urban development seizure,
so I choose to spend 3-4 days per week in similar club rooms, from Baltimore to NYC.

The group of engineers at HacDC helped me re-learn how to build and deploy code.
Rather than making a unique app to approach my problem,
I could easily plant seeds from other gardens into my local lab machines.
Perhaps I realized that no-code apps are essentially good enough -
especially since being amplified by the recent 'Vibe Coding' scene.

In any sense, I began to realize that I no longer used any of the lessons
I had picked up in college for program design and production -
C and C++ now seem to be silly choices,
Ruby and Rails border on dangerous,
Bash is irresponsible,
Git is corporatized,
and Data Structures have largely been solved.

As access to basic coding skills explodes in scale,
demand for commercial apps dips and skims near zero.
In corporate arenas, the remaining discussions have been organized in camps,
around opinions for frameworks; in essence - how quickly can you onboard your new engineers?
A once-cherished Computer Science degree has been replaced by discussions of dialect quirks.
I began looking beyond the apps, to the place real science has been hiding: in deployments.

- - -

Although many people expend discussions on program design,
those same people seem to hush when discussion leans
towards security, reliability, resilience, and durability; in essence, program deployment.

Once again: Deployments ensure that programs can be:

- Secure
- Reliable
- Resilient
- Durable

In nearly all of these norms, our national and global programs are seriously ill,
and local programs are dependent on endless proprietary help.
Our group of coders in the core of Congress had a Microsoft account manager,
inescapably present on all of the Microsoft-Teams managed discussions and operations calls.

An example of how deployments are ignored to a discouraging degree:

simple searches may bring up [index][demlab] upon [index][ctfg] of ready-and-able programs
to address a broad range of humane problems.
The programs are good, and done.
How come nearly no one uses them?

[demlab]: https://democracylab.org
[ctfg]: https://directory.civictech.guide

The problem of alignment on a sensible approach to deployments
has been a primary choking point for online producers, across all domains.
This problem has been seen most acutely in the Brigades,
which were always made-or-broken by the ease of sharing and repurposing peer-made codebases.

Before I joined CfA as a fellow, I had been going to the Code for San Francisco brigade for a year.
I'd been inspired by the idea that anyone could use the resources on hand
to connect to one another and build upon a common momentum.
Once I gained experience in the Brigades I realized that building each program is a small issue,
in comparison to reaching a launch, or sharing any success among geographically dispersed groups.
Now, I finally approached a playbook of guidance to address each main deployment concern.

- - -

As I said, I am honored to be accompanied in my learnings by the local hacker scene -
even last night was spent among an engaging, bubbling energy at NYC Resistor in Brooklyn,
where laptops were soon placed aside for synthesizers, to soon be replaced by knitting needles.

I learn many genious ideas generously shared by bloggers, who bring research from academia to practice;
primarily the researchers and producers surrounding [Ink & Switch][i&s].

[i&s]: https://inkandswitch.com

I am exceptionally lucky to be on the roll call for discussions
organized by the coders and builders in Congress,
who may never have a chance to design policy,
although their programs and procedures guide each motion of all legislation.

The more we can bring these groups to alignment on common ground and common aims,
the sooner we can clear the air in policymaking discussions.

Examples come to mind of the Senate Appropriations coder who made a line-by-line budget analysis app,
only to resign demoralized after producing alone and unrecognized for so many years.
Also in the scene are the many nonprofit advocates
who leap at any chance to educate Congress - about Congress.

Through all of these incredible and humbling relationships, I keep imagining each day may be one
where I come across a former Civic Tech builder - from the rich vein of practice that Code for America embodied.
Only, I imagine many of them are absorbed - now expelled? - by the executive branch.

An ironic consequence of Code for America's championing of logical machine code solutions
has been the degradation of policy -
the original legal code that binds our social order
has decayed inside a body easily ensared by corporate concerns.
These corporate predators are displaying unparalled hunger,
and their feeding ground has closed in on the home range of policy;
a new generation of energy is necessary to spur on any hope of the herd.

The new builders are here - and seek to help.
They'd like to build the basis of online dominion shared neighbor-to-neighbor,
to close ranks as guardians of the ideals most commonly cherished,
and to enable and encourage the crucial dialogues in any scenario where those principles remain unclear.

I hope you may be able to sponsor my attendance to this year's 2025 Summit in DC,
for 3 years the basis of my expanding home range.
If you can spare more passes, I'd be thrilled to recommend
colleagues across the legislative branch and nonprofit scene.

The ideal of democracy has no dependency on capital funding;
so our modern social order is clearly no longer democracy,
when Congress is paralyzed by crippled circulation and anxious nervous responses.
Please reclaim a place in the policymaking discussion
by ensuring those in Congress can hear your message;
all you need is to open the door.

Humbly,  
Calliope Youngblood
