---
name: A solid base.
composer: c4lliope
summary: Keeping a young coder from becoming an old curmudgeon.
labels:
  - learn
  - rebuild
  - solid
---

As I go along, in my career, I come across good ideas.

I rarely produce any of the caliber I see becoming popular online,
so I become good at learning the currents around me,
riding on the tide of popular opinion,
and adopting the drills and exercises of my peers.

Some people call me a mimic; this is fine.

- - -

Today I am looking back at my progress for the preceding year,
and I am realizing - there have been many false launches,
rugs pulled from under my feet, and otherwise unpredictable
occurrences keeping me from producing.
Sure, I keep sharp in some domains -
and occasionally I am able to build a solid base,
such as this essay engine you are reading, only -
as soon as I'm done building, I back up from the program and examine.

This Elixir app is nice. There are a couple unique, bespoke pieces.
You can change color schemes, and it reads source from git directly.

Those shiny angles are pleasing to me as a builder,
only they are rather silly in comparison to all of the shiny gems
I've passed up as I focused on this path.

As an example, I opened up a large box, labeled "Pandora" -
and a menagérie of [local-first designs][lofi] leaped hence.

[lofi]: https://www.inkandswitch.com/local-first-software/

As I explored the curious animals in this terrarium,
I came across one such who had compiled [`git` into `webassembly`][wagi].

[wagi]: https://wasm-git.petersalomonsen.com/

Amazing! Here I am, forcing you to ask my machine
to read a codebase for you, and relay the measures of code page by page.

Much simpler, here, to use the normal procedures for sharing code,
and help your machine learn to parse and display the pages locally.
And so, my gleaming aims of 2024 are seeming pale and dull already.

- - -

And alongside, I had imagined dynamic programs,
helping many people collaborate "on the same page".
Elixir and Phoenix are a superb approach to reach this baseline,
as I experienced. Only... they grew up a'fore my eyes.

[ElectricSQl](https://electric-sql.com/)
became a drop-in engine able to bring your records to users,
and immensely more usable alongside browser JavaScript packages
than the cludgy [Phoenix Hooks][hook] paradigm I had been using before.

[hook]: https://hexdocs.pm/phoenix_live_view/js-interop.html

This comparison, indeed, made me reconsider some of the compromises
I made along the road. How did my apps all come to look bland,
seem similar in appearance, and lack a unique flair?
Ah, the prevailing [Tailwind] of the day.

[Tailwind]: https://tailwindcss.com

Once I caught hold of the breeze, I fell for the allure of speed,
and had no eye for the rocky shoals ahead.
Here I am, praising color changes on an app,
when all of my styling rules reside in a single `.css` file.

In olden years, I'd harp on co-located styling rules,
and had even charted courses through web components,
the shipping lanes of the large corporate fleets.

And ho! Is this no less than the approach made possible by [UnoCSS],
or the colocation [explained by the solid-element][element] plugin?

[UnoCSS]: https://unocss.dev/
[element]: https://github.com/solidjs/solid/pull/2492/files

- - -

Alas, faded ambición.
My searches had persuaded me that the hull I had made
is shabby, dank, and dim.
In any case, far from able to carry me on to far-off seas.

And so, demoralized by my small corner hole I needed to huddle in,
I disconnected from the keyboard and pursued more music,
essays and lyrics replacing expressions and logic.

I am sincerely glad I did so, primarily for the sole memory I earned,
of being onstage, spotlights in my eyes, peering through the shine
into the deep silhouettes of an audience, ready to share and bare
the small remnants of soul I carry. Is a memory to seek again.

And so energized and dedicated, I come back aboard my small shabby ship,
and gaze around and realize, here is the place I abandoned my depression;
I see signs of the languid days piled all around,
and as I doze here the old emoción seeps back and the grip seals on me.

I need be quick, decide on impulse and act in assurance,
to build a road from this den of despair,
and reach once again through perspire and pursuance,
a small glimpse of sky and some much fresher air.

- - -

And this has brung me, by shedding assumpcións and implicacións,
to consider [Solid] as a replacement for my aims.

[Solid]: https://solidjs.com/

There is once again room to explore, to reach far horizons,
to build a base capable enough to carry real cargo,
to build up a hardy crew,
and to design courses pursuing liberacións more than escapes.

My ambivalence and disillusionment towards the course of React
has opened my gaze to an alternative line of attack;
one promising a broader channel and calmer passage,
and opening up choice of dirección for any heading one could choose.
