---
name: Open Source Summit, day 1.
composer: c4lliope
summary: No air in Denver.
labels:
  - open-source
  - confer
  - linux
---

The Linux Foundation's 2025 Open Source Summit launched today,
at the Colorado Convention Center in Denver -
where I've spent the last day collapsing on the ground
and engaging in Wim Hof breathing exercises,
to simply remain conscious through the day and recuperate from
many long hours on the road the prior week.

I am spending the conference camping in my pickup during the nights,
and have access to $150 or so for the next week.
I'm passing up on some of Denver's cuisine while I'm here,
although I am eager for a biscuit somehow.
I'll address the money issue soon enough.

So, rather than park in the conference center for $25/day,
I spent the morning in my brother's Boulder home rearranging the cab,
then found a place to park in Paco Sanchez park.
I rode my bicycle in for the lunch hour, missing the main keynotes.

The lunch had been arranged inside the sponsor gallery,
so I'd been pleased to run into Ericsson telecom -
the company behind Erlang (crucially underlying this domain),
and Automattic - the company behind [Wordpress](https://wordpress.org).

I told Ericsson's rep that they need to sieze their chance to build
a YouTube clone, using [Membrane](https://membrane.stream/) (or,
perhaps in a less captured market, a video compositor?).

For Automattic, I began discussing the issues I had seen
spread across a number of [LAMP]-stack applications;
the core ones being: Wordpress, Drupal, and MediaWiki.

[LAMP]: https://phoenixnap.com/kb/what-is-a-lamp-stack
[Wordpress]: https://wordpress.org/
[Drupal]: https://new.drupal.org/home
[MediaWiki]: https://www.mediawiki.org/wiki/MediaWiki

I'd been super-pleased to hear that in my quest to export
a bunch of Wordpress domains for re-use in other CMS harnesses,
I'd fully overlooked the public [REST API]
built into each Wordpress domain.

[REST API]: https://developer.wordpress.org/rest-api/

This alone is a breakthrough that is considerable for my purposes -
I had reached a similar approach for exporting Wiki pages,
using the built-in [Special:AllPages] and [Special:Export] combo.

[Special:AllPages]: https://wikiapiary.com/wiki/Special:AllPages
[Special:Export]: https://wikiapiary.com/wiki/Special:Export

Realizing that there is similar, fully public access to Wordpress pages
made my day before it really had a chance to begin.

Since the vegan lunch also sacrificed gluten from the bread recipe,
I peeled the foam off of the sandwich and nibbled down my salad
before loading up the [schedule] and preparing for my speed run.

[schedule]: https://events.linuxfoundation.org/open-source-summit-north-america/program/schedule/

The main themes of the day seemed to be:

- Software Bill of Materials (SBOM)
- AI hype of course
- Embedded deployments, mainly using [Zephyr]

[Zephyr]: https://www.zephyrproject.org/

[SBOM] concerns are most closely related to my government focus,
because they are crucial for supply-chain appraisal
and security assurances. Alongside those talks I sprinkled others,
such as documentation and continuous delivery,
as I dashed from room to room amid the hallway overflow discussions.

[SBOM]: https://www.cisa.gov/sbom

One talk focusing on open-source hardware
examined [ProtoCentral], and the [HealthyPi] boards.
The health focus of his group is super aligned to the engineers
I collaborate with each week, and as I become more engaged in making
I'd like to crack in to one of those boards - perhaps the mobile option.

[ProtoCentral]: https://protocentral.com/
[HealthyPi]: https://www.crowdsupply.com/protocentral/healthypi-5

The next speaker I chose had been discussing SBOM approaches,
and recommending how to respond to the endless cascade of [CVEs]
published each day - the vulnerabilities all of us dread.

[CVEs]: https://www.cve.org/

The group leading the discussion had been [DeployHub],
and I picked up links for [bomctl] and [Ortelius].
The speaker had been asking for 10 users to lead an adoption study,
so we exchanged ideas and are planning to discuss tomorrow
how to de-bloat an application's dependencies.
I'm eager as can be, and introduced by email before the talk ended.
I also need to look up [OpenSSF], as a related group here in Denver.

[DeployHub]: https://www.deployhub.com/open-source-vulnerability-management/
[bomctl]: https://pkg.go.dev/github.com/bomctl/bomctl
[Ortelius]: https://ortelius.io/
[OpenSSF]: https://openssf.org/

Then began the conference zoomies,
because I sat down in the hall and pulled up each talk for the next hour,
chose the compelling ones, and mapped their location in the hall.

Then in no real order, I peeked in on:

- The [TODO](https://todogroup.org/) group -
  advocating for corporate recognition of their open-source obligations.
- [Open Mobile Hub](https://openmobilehub.org/sdk/),
  a panel with no real cohesion and an unsure mood. Meh?
- [OpenSearch](https://opensearch.org/), which may be the only laudable
  product I've ever heard promoted by an Amazon engineer.
  The open-source program seems to have minimal corporate reliance.

Then, once I thought I'd been done for the third time,
I found the [CD Foundation](https://cd.foundation/).
The discussion here was led by the [Edge Monsters],
and they had on stage a real, running mobile lab -
seemingly pulled out of a Pelican case,
and ready to be loaded onto an airplane.

One of the speakers, a member of the Air Force,
claimed that the lab had been to 7 countries,
in over 40 demos - and he happily pulled different blades
from the rig with no ceremony, sure that the balance
would be rearranged in the absence of 1/3 the silicon resources.

There was some impressively granular discussion of the components,
although more happily the design
has been approved for open-source release... soon?
I need to email to double-check the link and release plans.

[Edge Monsters]: https://edgemonsters.dev/

So concludes the open source summit day 1.
I'm happy for a chance to record many of these experiences
before the convention center closes in... 10 minutes.

I'll need each spare second to run the 6 miles to the other side
of the building, by the blue bear, where my bike is parked,
before picking up some dinner fixin's at the local Sprout's.

Is a really big building, and the peaks look good from up here.
Perhaps more pictures to come - for now, big ideas to explore.


![A big, blue, bear peering in on the Colorado Convention Center.][bear.jpg]

[bear.jpg]: https://share.operand.online/gram/page/media/2025-06-23.bear.jpg
