---
name: Codebase Relay
composer: c4lliope
summary: Run `ssh -p 2202 base.operand.online` and examine our code.
labels:
  - deploy
  - codebase
  - git
---

A day ago I discussed [a broad plan] to rebuild ://operand.online;
the challenges are already becoming clear. All the same, some progress!

[a broad plan]: /chronicle/oss.backlog

I focused today on the first motion necessary to upgrade the blog -
changing from the clunky `share.operand.online` to a real `git` relay,
so that someday I can run `git clone` to copy the markdown to the web client,
where I'll rely on [SolidJS] and [MDX] to compile the pages.

[SolidJS]: https://solidjs.com
[MDX]: https://mdxjs.com

The essays are in [gram:page], the web code is in [gram:op],
and the deployment code is in [gram:build].

[gram:page]: /gram/page
[gram:op]: /gram/op
[gram:build]: /gram/build

So far I'm doing all of the rendering for the essays
in Elixir, a fabulous language that has a higher calling
than the rendering of markdown.

To change this, I need to first focus on deploying
a new relay program, called `soft-serve`;
you can `ssh git.charm.sh` as an example,
or see my deployed copy at: `ssh -p 2202 base.operand.online`.
I recorded a console session as I [hooked this up in NixOS][nix].

[nix]: https://search.nixos.org/options?channel=25.05&show=services.soft-serve.settings&size=50&sort=relevance&type=packages

Now, the relay is up and running. Yay!
That is as far as I made it,
because the next piece is so uncommon....
that no one really goes that far yet.
This is the cool, unknown-frontier piece of coding.
We're gonna be in a danger zone from here on.

To be specific about today's errors that are holding me up,
I'm seeing different problems locally and in deployment.

Locally, there seems to be a CORS error when I make a connection
to `https://base.operand.online` - an HTTP 405 "Method Not Allowed".
I see [someone else] added code to handle this problem,
and somehow it does me no good.
Perhaps the issue is that on my local machine,
I am running the app on HTTP rather than HTTPS.
CORS (cross-origin request security) becomes picky on such conditions.

[someone else]: https://github.com/charmbracelet/soft-serve/pull/516

So, I merged my branch into main and pushed -
and the compilation broke because in 2025,
compiling to webassembly remains a hard problem somehow.
I'm usually amused when I see errors decrying a bad "[magic number]";
though today I am less than amused - I need this connection.

[magic number]: https://github.com/WebAssembly/design/issues/1328

Now, `libgit2.c` is a shady binary to compile to webassembly,
because the compilation target has been pinned like a donkey-tail
to the braying ass of a language.

If I'm going to proceed, I'll be much happier using [GitOxide],
since much less can go badly when cross-compiling Rust,
and I'm beginning to learn a sense of the language tooling.

[GitOxide]: https://crates.io/crates/gitoxide

I'm surprised to say that I'm no longer scared to dig through Rust code -
somehow speaking to a bunch of open-source coders who depend on Rust
makes the language seem more human, more approachable.

My textbook from No Starch Press has no mention of webassembly, though!
I'll be choosing from some capable blog guidance.
(
[1](https://developer.mozilla.org/en-US/docs/WebAssembly/Guides/Rust_to_Wasm),
[2](https://surma.dev/things/rust-to-webassembly/),
[3](https://rustwasm.github.io/book/),
[4](https://depth-first.com/articles/2020/06/29/compiling-rust-to-webassembly-a-simple-example/),
)

- - -

Although the blog rendering procedure remains unchanged,
I now have a new git codebase relay up and running,
happily secured and managed using SSH,
and honoring my user SSH keys.

I can now confidently synchronize code again!

Since I spun up the "baseline lab" in Maryland,
I've been doing a bunch of on-relay code changes,
especially for the code I'm using to clone [static.case.law].

[static.case.law]: https://static.case.law

Those code changes are soon going to be added
to the [gram:build] codebase,
although I'm not looking forward to the merges
after a few weeks of divergence between my laptop and the lab.

Sundays are my de facto day off,
based on library schedules,
and I'm lucky to be busy tomorrow with the Denver Pride fest.
I'll sign off here and hope to be back on Monday,
sharing anything I picked up around Rust and WASM in the meanwhile.
