---
name: Upgrade; Relay Display
composer: c4lliope
summary: Display producción subdomains being relayed by Caddy.
labels:
  - nushell
  - elixir
  - caddy
  - deploy
  - upgrade
  - record
public: false
---

I spent a bunch of hours yesterday playing around in Caddy;
I had to make up some rules that could be applied to the [Baltimore Node]
domain, which has been running on NGINX until now.

Going through the documentation again,
I am reminded that there is a solid [REST API],
which some people presumably use to change routing on the fly.
Some people are used to risky edge cases, I guess.

[Baltimore Node]: https://baltimorenode.org
[REST API]: https://caddyserver.org/docs/api

I realized that I could rather simply access this API
using [nu]'s built-in `http get` command,
so I happily played around on different API routes,
and then different nushell pipelines,
until I captured a real nice summary of the domains I need.

[nu]: https://nushell.sh

Kicking myself because I hadn't begun recording earlier in the morning,
I committed to finishing the process on camera -
er, on screen. On mic?

Anyhou, here are the proceedings:
a really simple exercise in combining nushell code into an elixir app.

<video controls>
<source src="https://share.operand.online/rec/2025-07-02.relay.rec/relay.mp4" type="video/mp4">
</video>

This is something that I really had planned on for ages -
only I had as usual made the problem more complex than it needed to be.

The original mechanism I had imagined was to use [Rustler]
to compile bindings to the [Nu rust package];
then to call the Rust code directly from the same process as the Elixir app.

[Rustler]: https://hexdocs.pm/rustler/readme.html
[Nu rust package]: https://crates.io/crates/nu

None of that was necessary.
In the end, Nu is a shell,
and is happy to compile and run any code tossed to it from the command line,
or through a system cmd execución - easy and common in any programming language.

As reference, see:

- [gram:build/config/nushell/relay.nu](https://operand.online/gram/build/config/nushell/relay.nu)
- [gram:op/lib/op_web/live/domain/index.ex](https://operand.online/gram/op/lib/op_web/live/domain/index.ex)
- [gram:op/lib/op_web/live/domain/index.html.heex](https://operand.online/gram/op/lib/op_web/live/domain/index.html.heex)

If you'd like to see more, please say so!

Most of my coding is done in nu,
so now that I opened this door
there is no end to how these code bases can be combined.

As you can perhaps see in the second open tab,
my next real challenge is to change from server-rendering,
to client-side [SolidJS].
I plan to follow obey the guidance of [ndrean/phoenix_solid],
and perhaps record the process as I do so.

[SolidJS]: https://solidjs.com
[ndrean/phoenix_solid]: https://github.com/ndrean/phoenix_solid

I really liked the format of old [Peepcode] screen recordings,
so I'm rolling the dice on similar, ad-hoc, goal-oriented coding sessions.
If you have ideas on how I can more quickly stream these
(in an open-source manner, of course) -
please refer to these modules before you [email me]:

- [gram:build/config/nushell/screen.nu](http://operand.online/gram/build/config/nushell/screen.nu)
- [audio-recorder](https://launchpad.net/~audio-recorder)
- [waystream](https://github.com/bbusse/waystream)
- [membrane](https://membrane.stream/)

[Peepcode]: https://github.com/peepcode
[email me]: mailto:inbound@operand.online
