---
name: Space to Build
composer: c4lliope
summary: |
  I'm beginning to imagine the nuances of a peer-to-peer product,
  similar to [LiveBook] and [Observable], based on [Tauri],
  and embracing the ideals of [Local First] programming.
labels:
  - code  
  - peer comms
  - program
  - build
---

I'm beginning to imagine the nuances of a peer-to-peer product,
similar to [LiveBook] and [Observable], based on [Tauri],
and embracing the ideals of [Local First] programming.

[Why bother?][feudalism]

To approach Tauri, the desktop-app layer, I am upskilling in [Rust] -
and gearing up a dependable [webassembly] compiler pipeline.
Tauri 2.0 adds mobile apps to the mix, including iOS and Android.

My primary lang, [Elixir], can run code dispersed on thousands of machines,
and is the same base layer chosen by WhatsApp, Discord, and Telecom of old.
Elixir and similar langs are making inroads to webassembly through [AtomVM].

A bunch of pixels (electrons?) [have been spilled][plan]
in discussion of client-side libraries, rendering pipelines,
and [the issue of a dense bundler landscape][bundles].

These are the pieces that I feel I needed to learn,
simply to build at the level that an end-user expects.

Since my first company in 2017,
I had the idea that a single human should be able
to harness the energy of machines to build useful apps,
and fly in the face of the market and industry if needed.

There are too many apps that I'd like to build,
to choose only one; so I focus on the process of app-making.

As a consequence...
I'm ready to build a seamless channel from GPU to GUI,
so people can build and share from any machine,
either in a board room or on a beach,
in café or construction,
factory floor or farm field.

- - -

With all the chaos of change in the air these prior few years,
I'm sure the remaining online boom of the 2020s
has to focus on education, to rebuild a common language around our programs,
and condense new labor pools from the displaced employees of the recession.

Only, am I going to be the one to lead the lesson?

No; I only know code and how to apply code to build programs.
I'd like to learn from others,
people who manage more serious problems than code.
The program is designed around helping
people share and discuss their learnings, in any discipline.

I spent years helping people, young and old, learn code -
and there needs to be a clear place to land once a child outgrows Scratch.

I spent years among lawyers learning the nuances of the business -
and they need an app to change a spare GPU into an on-premise pipeline.

It is impossible for our machine learning apps
to find - or build - audiences
that resemble the era of blogs, consumer SAAS, or B2B products.
In a sense, 'audience' is no longer meaningful.

We need to keep in mind that a "Fortune 500 Product"
is now being challenged by a $500 ebay purchase.

We need to realize that anyone can build, if they have the space.

We need to make space to build.

[LiveBook]: https://livebook.dev/
[Observable]: https://observablehq.com/
[Tauri]: https://tauri.app/
[Local First]: https://www.inkandswitch.com/local-first-software
[webassembly]: https://webassembly.org/
[bundles]: /chronicle/bundles
[Rust]: http://rust-lang.org/
[Elixir]: https://elixir-lang.org/
[AtomVM]: https://www.atomvm.net/
[plan]: /chronicle/publishing.plan
[feudalism]: /chronicle/feudalism
