---
name: Program Drop
composer: c4lliope
summary: |
  [`pool`](/gram/pool) your resources, and `drop` your programs on a spare machine.

  [![screen][screen]][screen]

  [screen]: https://share.operand.online/gram/page/media/2025-10-13.neo4j.drop.png

labels:
  - NixOS
  - pool
  - launch
---

Ages ago at HacDC, in October 2023, people sparked my curiosity for NixOS.
Early on, I became inspired by a guy named `astro`
who was building the slickest VM-management layer I’d seen.

[Obligatory CCC link enclosed](https://media.ccc.de/v/nixcon-2023-34861-microvm-nix).

2 years passed as I learned enough Nix to make sense of the docs. I have gone without docker or containers for too damn long. No one should need to learn all the edge cases of `astro`’s package, and all of us should be using his approach. So, how do?

I’m rather pleased today to launch a new package, for pooling programs as NixOS VMs:

[gram/pool](/gram/pool)

## Launch Dialogues

> Calliope, 1:05 AM

There has been so much consideration placed behind this,
I'm thrilled to begin building up from here.
Maybe I'll finally climb back down from the`ops` peak soon
and head back to the rolling hills of app design.

> Calliope, 10:56 AM

Here is a real deployment-grade program running on pool.
This dense screen is displaying, from left to right, top-to-bottom:

* A running microVM, on a local-only IP address of 10.0.0.31, running Neo4j
  * `lsmem`
  * `ip a`
  * `journalctl -fu neo4j`
* An Elixir/Phoenix connection to this Neo4j db
  * setup guide (neo4j password)
  * phoenix config
  * phoenix console using boltx library
* <https://microvm-nix.github.io/microvm.nix>
* <https://hexdocs.pm/boltx/readme.html>

Search for neo4j on:
<https://operand.online/gram/pool/flake.nix>

and see more options on:
<https://search.nixos.org/options?channel=25.05&query=services.neo4j>

There are a half-dozen other apps I'd like to add in, at a pace of 2-3 per day,
before I give this a spin on my lab at the Baltimore Node hackerspace.

> Calliope, 11:03 AM

Remaining issues:

* per-pod namespacing

  > VMs are now named only per-app,
  so only one copy of an app can be running at any moment.
  This error comes across when accessing `tap` on `/dev/net/tun`.

* reliable networking

  > [Nebula](https://nebula.defined.net/) should be used to ensure
  programs can be dropped on myriad machines in an ad-hoc manner,
  and IP mappings and routing remain in place.


* prepare subdomains using caddy

  > caddy can proxy traffic and assign SSL certs,
  for easy domain-name management;
  with all unencrypted networking confined to a single machine.
