import Config

config :pain, Pain.Repo,
  username: "postgres",
  password: "postgres",
  hostname: "localhost",
  database: "pain_local",
  stacktrace: true,
  show_sensitive_data_on_connection_error: true,
  pool_size: 10

# In local mode, disable any cache and enable debugging and code reloading.
config :pain, PainWeb.Endpoint,
  http: [ip: {0, 0, 0, 0}, port: System.get_env("CHANNEL") || 4000],
  check_origin: false,
  code_reloader: true,
  debug_errors: true,
  secret_key_base: "Qc5UoPv4JXrn5egLUlIKrnpKh0p2j5QRXrwGlwFmWNgaAorPBWL4z3nJUBJtf7mf",
  reloadable_compilers: [:gettext, :elixir, :app, :surface],
  server: true,
  watchers: [
    node: ["build.js", "--watch", cd: Path.expand("../assets", __DIR__)],
  ],
  live_reload: [
    patterns: [
      ~r"lib/pain_web/(controllers|live|components)/.*(ex|heex|sface|js)$",
      ~r"priv/catalogue/.*(ex)$",
      ~r"priv/gettext/.*(po)$",
      ~r"priv/static/.*(js|css|png|jpeg|jpg|gif|svg)$",
    ],
    reload_page_on_css_changes: true,
  ]

# Enable dev routes for dashboard and mailbox
config :pain, dev_routes: true
# Do not include metadata nor timestamps in development logs
config :logger, :console, format: "[$level] $message\n"
# Set a higher stacktrace during development.
# Avoid configuring such in production as building large stacktraces may be expensive.
config :phoenix, :stacktrace_depth, 20
# Initialize plugs at runtime for faster development compilation
config :phoenix, :plug_init_mode, :runtime

# ## SSL Support
#
# In order to use HTTPS in development, a self-signed
# certificate can be generated by running the following
# Mix task:
#     mix phx.gen.cert
# Run `mix help phx.gen.cert` for more information.
# The `http:` config above can be replaced with:
#     https: [
#       port: 4001,
#       cipher_suite: :strong,
#       keyfile: "priv/cert/selfsigned_key.pem",
#       certfile: "priv/cert/selfsigned.pem"
#     ],

# If desired, both `http:` and `https:` keys can be
# configured to run both http and https servers on
# different ports.

# Disable swoosh api client as it is only required for production adapters.
# config :swoosh, :api_client, false
