import Config

# The secret key base is used to sign/encrypt cookies and other secrets.
# A default value is used in config/dev.exs and config/test.exs but you
# want to use a different value for prod and you most likely don't want
# to check this value into version control, so we use an environment
# variable instead.
secret_key_base =
  System.get_env("SECRET_KEY_BASE") ||
    raise """
    environment variable SECRET_KEY_BASE is missing.
    You can generate one by calling: mix phx.gen.secret
    """

# Note we also include the path to a cache manifest
# containing the digested version of static files. This
# manifest is generated by the `mix assets.deploy` task,
# which you should run after static files are built and
# before starting your production server.
config :pain, PainWeb.Endpoint,
  server: true,
  http: [ ip: {127, 0, 0, 1}, port: System.get_env("CHANNEL") ],
  cache_static_manifest: "priv/static/cache_manifest.json",
  secret_key_base: secret_key_base

# Configures Swoosh API Client
# config :swoosh, api_client: Swoosh.ApiClient.Finch, finch_name: Pain.Finch

# Disable Swoosh Local Memory Storage
# config :swoosh, local: false

# Do not print debug messages in production
config :logger, level: :info

# Runtime production configuration, including reading
# of environment variables, is done on config/runtime.exs.
