defmodule Pain.Application do
  # See https://hexdocs.pm/elixir/Application.html
  # for more information on OTP Applications
  @moduledoc false

  use Application

  @impl true
  def start(_type, _args) do
    children = [
      # Start the Telemetry supervisor
      PainWeb.Telemetry,
      # Start the Ecto repository
      # Pain.Repo,
      # Start the PubSub system
      {Phoenix.PubSub, name: Pain.PubSub},
      # Start Finch
      {Finch, name: Pain.Finch},
      # Start the Endpoint (http/https)
      # { Plug.Cowboy, scheme: :http, plug: PainWeb.Endpoint },
      PainWeb.Endpoint,
      # Start a worker by calling: Pain.Worker.start_link(arg)
      # {Pain.Worker, arg}
    ]

    # See https://hexdocs.pm/elixir/Supervisor.html
    # for other strategies and supported options
    opts = [strategy: :one_for_one, name: Pain.Supervisor]
    Supervisor.start_link(children, opts)
  end

  # Tell Phoenix to update the endpoint configuration
  # whenever the application is updated.
  @impl true
  def config_change(changed, _new, removed) do
    PainWeb.Endpoint.config_change(changed, removed)
    :ok
  end
end
