defmodule Pain.MixProject do
  use Mix.Project

  def project do
    [
      app: :pain,
      version: "0.1.0",
      docs: [
        main: "Pain",
        canonical: "https://share.operand.space/gram/pain/doc/readme.html",
        extras: ["README.md"]
      ],
      elixir: "~> 1.18",
      elixirc_paths: elixirc_paths(Mix.env()),
      start_permanent: Mix.env() == :prod,
      aliases: aliases(),
      deps: deps(),
      compilers: Mix.compilers() ++ [:surface]
    ]
  end

  # Configuration for the OTP application.
  #
  # Type `mix help compile.app` for more information.
  def application do
    [
      mod: {Pain.Application, []},
      extra_applications: [:logger, :runtime_tools]
    ]
  end

  # Specifies which paths to compile per environment.
  defp elixirc_paths(:test), do: ["lib", "test/support"] ++ catalogues()
  defp elixirc_paths(:dev), do: ["lib"] ++ catalogues()
  defp elixirc_paths(_), do: ["lib"]

  # Specifies your project dependencies.
  #
  # Type `mix help deps` for examples and options.
  defp deps do
    [
      {:dotenv, "~> 3.0.0", only: [:dev, :test]},
      {:ex_doc, "~> 0.14", only: :dev, runtime: false},
      {:live_debugger, "~> 0.4.0", only: :dev},
      {:phoenix_live_reload, "~> 1.2", only: :dev},

      {:floki, ">= 0.30.0", only: :test},

      {:phoenix, "~> 1.7"},
      {:phoenix_ecto, "~> 4.4"},
      {:phoenix_html, "~> 3.3"},
      {:phoenix_live_dashboard, "~> 0.8"},
      {:phoenix_live_view, "~> 0.20.10"},

      {:bandit, "~> 1.0"},
      {:ecto_sql, "~> 3.10"},
      {:ex_heroicons, "~> 2.0"},
      {:finch, "~> 0.13"},
      {:gettext, "~> 0.20"},
      {:jason, "~> 1.2"},
      {:postgrex, ">= 0.0.0"},
      {:req, "~> 0.5"},
      {:surface, "~> 0.11.0"},
      {:surface_catalogue, "~> 0.6.0"},
      # {:swoosh, "~> 1.16"},
      {:telemetry_metrics, "~> 1.0"},
      {:telemetry_poller, "~> 1.1"},
      # {:tzdata, "~> 1.1"},
      {:yaml_elixir, "~> 2.9"},
    ]
  end

  # Aliases are shortcuts or tasks specific to the current project.
  # For example, to install project dependencies and perform other setup tasks, run:
  #
  #     $ mix setup
  #
  # See the documentation for `Mix` for more info on aliases.
  defp aliases do
    [
      setup: ["deps.get", "ecto.setup", "assets.build", "assets.deploy"],
      "ecto.setup": ["ecto.create", "ecto.migrate", "run priv/repo/seeds.exs"],
      "ecto.reset": ["ecto.drop", "ecto.setup"],
      test: ["ecto.create --quiet", "ecto.migrate --quiet", "test"],
      "assets.build": ["cmd 'cd assets && node build.js'"],
      "assets.deploy": ["cmd 'cd assets && node build.js --deploy'", "phx.digest"],
    ]
  end

  def catalogues do
    [
      "priv/catalogue"
    ]
  end
end
