import Config

# The secret key base is used to sign/encrypt cookies and other secrets.
# A default value is used in config/dev.exs and config/test.exs but you
# want to use a different value for prod and you most likely don't want
# to check this value into version control, so we use an environment
# variable instead.

# Note we also include the path to a cache manifest
# containing the digested version of static files. This
# manifest is generated by the `mix assets.deploy` task,
# which you should run after static files are built and
# before starting your production server.
config :pain, PainWeb.Endpoint,
  server: true,
  check_origin: ["https://pain.fly.dev", "https://book.painawayofphilly.com"],
  url: [
    scheme: "https",
    host: System.get_env("DOMAIN"),
    port: 443,
  ],
  http: [ ip: {0, 0, 0, 0}, port: System.get_env("CHANNEL") ],
  cache_static_manifest: "priv/static/cache_manifest.json",
  secret_key_base: System.get_env("SECRET_KEY_BASE")

# Configures Swoosh API Client
# config :swoosh, api_client: Swoosh.ApiClient.Finch, finch_name: Pain.Finch

# Disable Swoosh Local Memory Storage
# config :swoosh, local: false

# Do not print debug messages in production
config :logger, level: :info

# Runtime production configuration, including reading
# of environment variables, is done on config/runtime.exs.
