# pool

> a [Nix] package based on [microvm.nix]

[Nix]: https://nixos.org
[microvm.nix]: https://microvm-nix.github.io/microvm.nix

- - -

Our machines should be less concerned by the programs they run;
so long as each one is in a nice small bounded zone.

Here is phase one.

## Philosophy.

You'd like to "drop" your programs onto machines in an ad-hoc manner,
using any organizing premise you choose.

When you are simply engaging and disengaging programs,
there is no need to keep the program recipe (config) in the same flake
as your base machine. This codebase is a collection of those program recipes.

Because your base machine becomes a collection of many "dropped" programs,
this operation is called "pooling" programs onto a machine.

> [microvm.nix] helps to reduce resource demand and emphasize caching,
using normal [Nix] approaches.

## Dig in.

Using a `NixOS` machine as your base layer,
clone this codebase as `/pool`.

In your `/etc/nixos/flake.nix` (you're using flakes, I hope), add:

```nix
{ inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixos-25.05";
    pool = { url = "/pool"; inputs.nixpkgs.follows = "nixpkgs"; };
  };

  outputs = { microvm, pool, nixpkgs, ... }: let
    lib = nixpkgs.lib; in
  in {
    nixosConfigurations.mach = lib.nixosSystem {
      # ... any nix code you choose.
      modules = [
        sources.microvm.nixosModules.host
        # here, use your machine's primary outbound internet connection.
        (pool.channel.${sources.arch} "eno1")
      ];
    };
  };
}
```

## Make rain.

```nu
# `a` is the label of our original machine image.
sudo nix run /pool#a
```

- You should see a machine spin up;
- the normal login is `root`, and no passcode required.
- The normal shell is `nushell`.
- Ensure DHCP assigned an IP addres, using `ip a`.
- From the base machine, `ssh someone@<IP>`, passcode `abcd1234`.
- Sign in easier by filling in `roles.<name>.keys = [];`, using your SSH key.
- DHCP is used on the `10.0.0.2/24` address space; Nebula is encouraged from there.
- Close the machine, using `shutdown now` as a superuser.
- `/pool` is used so images can be recorded in `/pool/disc`.
- Internet-patching requires super-user permissions, so `/pool` seems sensible.

Recipes are going to be added as a rapid pace,
based on 3 prior years of home-lab nix-code buildup.

> Please message [`code@operand.online`][mail] and describe any issues you experience.

[mail]: mailto:code@operand.online
