{ pkgs, addr, plug, ...}:
let
  role = import ../basis/role.nix { inherit pkgs; };
  address = import ../basis/address.nix { inherit pkgs; } plug;
in {
  roles = {
    root = role "root" {} {};
  };

  module = {
    imports = [
      (address addr)
      ../module/psql.nix

      ( import ../gram/elixir.nix {
        base = "op"; name = "op"; channel = 4000;
        user = "root"; codebase = "/root/share/gram/op";
      })
    ];

    environment.systemPackages = with pkgs; [ isd helix
      elixir nodejs yarn git libgit2 gnupg openssl inotify-tools nushell
    ];
    networking.firewall.allowedTCPPorts = [ 4000 5173 ];
  };

  shares = [ {
    # use proto = "virtiofs" for MicroVMs that are started by systemd
    proto = "9p";
    tag = "home";
    # a host's /nix/store will be picked up so that no
    # squashfs/erofs will be built for it.
    source = "/home/calliope/share";
    mountPoint = "/root/share";
  } ];

}
