{ microvm, ... }:
signal:
{
  # [upgrade] pass in microvm configs ready for `autostart`
  # microvm.hypervisor = "cloud-hypervisor";

  imports = [ microvm.nixosModules.host ];

  networking.useNetworkd = true;
  # Inbound DHCP calls
  networking.firewall.allowedUDPPorts = [ 67 ];
  networking.nat = {
    enable = true;
    enableIPv6 = true;
    internalInterfaces = ["pool"];
    # [upgrade] pass in `exexternalInterface` as a param.
    externalInterface = signal;
  };

  # microvm `pool` interface
  systemd.network = {
    enable = true;
    netdevs."pool".netdevConfig = { Name = "pool"; Kind = "bridge"; };
    networks."pool" = {
      matchConfig.Name = "pool";
      networkConfig = { DHCPServer = true; IPv6SendRA = true; };
      addresses = [
        # [upgrade] pass in sub-ranges as a param.
        { addressConfig.Address = "10.0.1.1/24"; }
        { addressConfig.Address = "fd12:3456:789a::1/64"; }
      ];
      ipv6Prefixes = [
        { ipv6PrefixConfig.Prefix = "fd12:3456:789a::/64"; }
      ];
    };

    # non-public `pool` of drops running on this machine.
    networks."drop" = {
      matchConfig.Name = "drop.*";
      networkConfig.Bridge = "pool";
    };
  };
}
