{ pkgs, microvm, lib, ... }@params:
label: addr: plug: recipe:
lib.nixosSystem {
  inherit pkgs;
  system = pkgs.system;
  specialArgs = pkgs.lib.mergeAttrs params { inherit label; };
  modules = [
    microvm.nixosModules.microvm
    ./basis/engine.nix
    ./basis/memory.nix
    ./basis/cache.nix
    ./basis/essence.nix
    ./basis/signal.nix
    ./basis/disc.nix
    ./basis/access.nix
    (import ./basis/address.nix plug addr)
    recipe
  ];
}
