{ pkgs, ...}:
let
  role = import ../basis/role.nix { inherit pkgs; };
in {
  networking.firewall.allowedTCPPorts = [ 8000 ];
  users.users = { root = role "root" {}; };
  imports = [ ../module/surreal.nix ];
  environment.systemPackages = with pkgs; [
    gnupg openssl inotify-tools nushell
    isd helix
  ];

  # microvm.shares = [ {
  #   # use proto = "virtiofs" for MicroVMs that are started by systemd
  #   proto = "9p";
  #   tag = "home";
  #   # a host's /nix/store will be picked up so that no
  #   # squashfs/erofs will be built for it.
  #   source = "/home/calliope/share";
  #   mountPoint = "/root/share";
  # } ];
}
