{ description = "NixOS in MicroVMs";
  inputs = {
    microvm = {
      url = "github:microvm-nix/microvm.nix";
      inputs.nixpkgs.follows = "nixpkgs";
    };
    nixpkgs.url = "github:nixos/nixpkgs/nixos-25.11";
  };

  outputs = { self, nixpkgs, microvm }: let
    params = arch: {
      lib = nixpkgs.lib;
      pkgs = import nixpkgs { system = arch; };
      inherit microvm;
    };

    arch = "x86_64-linux";
    plug = "enp0s6";

  in rec {
    current = arch: {
      condense = import ./condense.nix (params arch);
      role = import ./basis/role.nix (params arch);
      channel = signal: import ./channel.nix (params arch) signal;
    };

    # residual
    nixosConfigurations = let local = current "x86_64-linux"; in {
      minimal = local.condense "minimal" "10.0.1.4" plug { users.users.root = local.role "root" {}; };
      op = local.condense "op" "10.0.1.8" plug (import ./drop/op.nix);
      pod = local.condense "pod" "10.0.1.9" plug (import ./drop/pod.nix);
    };

    # residual
    packages.${arch} = {
      minimal = nixosConfigurations.minimal.config.microvm.declaredRunner;
      op = nixosConfigurations.op.config.microvm.declaredRunner;
    };
  };
}
