{ pkgs, ...}:
let
  role = import ../basis/role.nix { inherit pkgs; };
in {
  users.users = { root = role "root" {}; };

  imports = [
    ../module/psql.nix

    ( import ../drop/elixir.nix {
      base = "drop"; name = "drop"; channel = 4000;
      user = "root"; codebase = "/root/share/gram/drop";
    })
  ];

  environment.systemPackages = with pkgs; [
    helix nushell isd inotify-tools
    gnupg openssl
    elixir
  ];
  networking.firewall.allowedTCPPorts = [ 4000 ];

  microvm.shares = [ {
    # use proto = "virtiofs" for MicroVMs that are started by systemd
    proto = "9p";
    tag = "home";
    # a host's /nix/store will be picked up so that no
    # squashfs/erofs will be built for it.
    source = "/home/calliope/share";
    mountPoint = "/root/share";
  } ];

}
