{ nixpkgs, pkgs, arch, microvm, ... }@params:
label:
{ module ? {}, roles ? {}, ... }:
{
  name = label;
  value = nixpkgs.lib.nixosSystem {
    system = arch; inherit pkgs;
    specialArgs = nixpkgs.lib.mergeAttrs params { inherit label; };
    modules = [
      microvm.nixosModules.microvm
      ./basis/engine.nix
      ./basis/memory.nix
      ./basis/cache.nix
      ./basis/essence.nix
      ./basis/signal.nix
      ./basis/disc.nix
      ./basis/access.nix
      module
      { users.users = roles; }
    ];
  };
}
